/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SearchAlteration;
import com.microsoft.graph.models.SearchAlterationType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AlterationResponse
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AlterationResponse() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AlterationResponse createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AlterationResponse();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("originalQueryString", n -> this.setOriginalQueryString(n.getStringValue()));
        deserializerMap.put("queryAlteration", n -> this.setQueryAlteration((SearchAlteration)n.getObjectValue(SearchAlteration::createFromDiscriminatorValue)));
        deserializerMap.put("queryAlterationType", n -> this.setQueryAlterationType((SearchAlterationType)n.getEnumValue(SearchAlterationType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOriginalQueryString() {
        return (String)this.backingStore.get("originalQueryString");
    }

    @Nullable
    public SearchAlteration getQueryAlteration() {
        return (SearchAlteration)this.backingStore.get("queryAlteration");
    }

    @Nullable
    public SearchAlterationType getQueryAlterationType() {
        return (SearchAlterationType)((Object)this.backingStore.get("queryAlterationType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("originalQueryString", this.getOriginalQueryString());
        writer.writeObjectValue("queryAlteration", (Parsable)this.getQueryAlteration(), new Parsable[0]);
        writer.writeEnumValue("queryAlterationType", (Enum)this.getQueryAlterationType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOriginalQueryString(@Nullable String value) {
        this.backingStore.set("originalQueryString", (Object)value);
    }

    public void setQueryAlteration(@Nullable SearchAlteration value) {
        this.backingStore.set("queryAlteration", (Object)value);
    }

    public void setQueryAlterationType(@Nullable SearchAlterationType value) {
        this.backingStore.set("queryAlterationType", (Object)value);
    }
}

