/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.graph.models.TargetedManagedAppProtection;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AndroidManagedAppProtection
extends TargetedManagedAppProtection
implements Parsable {
    public AndroidManagedAppProtection() {
        this.setOdataType("#microsoft.graph.androidManagedAppProtection");
    }

    @Nonnull
    public static AndroidManagedAppProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AndroidManagedAppProtection();
    }

    @Nullable
    public List<ManagedMobileApp> getApps() {
        return (List)this.backingStore.get("apps");
    }

    @Nullable
    public String getCustomBrowserDisplayName() {
        return (String)this.backingStore.get("customBrowserDisplayName");
    }

    @Nullable
    public String getCustomBrowserPackageId() {
        return (String)this.backingStore.get("customBrowserPackageId");
    }

    @Nullable
    public Integer getDeployedAppCount() {
        return (Integer)this.backingStore.get("deployedAppCount");
    }

    @Nullable
    public ManagedAppPolicyDeploymentSummary getDeploymentSummary() {
        return (ManagedAppPolicyDeploymentSummary)this.backingStore.get("deploymentSummary");
    }

    @Nullable
    public Boolean getDisableAppEncryptionIfDeviceEncryptionIsEnabled() {
        return (Boolean)this.backingStore.get("disableAppEncryptionIfDeviceEncryptionIsEnabled");
    }

    @Nullable
    public Boolean getEncryptAppData() {
        return (Boolean)this.backingStore.get("encryptAppData");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("apps", n -> this.setApps(n.getCollectionOfObjectValues(ManagedMobileApp::createFromDiscriminatorValue)));
        deserializerMap.put("customBrowserDisplayName", n -> this.setCustomBrowserDisplayName(n.getStringValue()));
        deserializerMap.put("customBrowserPackageId", n -> this.setCustomBrowserPackageId(n.getStringValue()));
        deserializerMap.put("deployedAppCount", n -> this.setDeployedAppCount(n.getIntegerValue()));
        deserializerMap.put("deploymentSummary", n -> this.setDeploymentSummary((ManagedAppPolicyDeploymentSummary)n.getObjectValue(ManagedAppPolicyDeploymentSummary::createFromDiscriminatorValue)));
        deserializerMap.put("disableAppEncryptionIfDeviceEncryptionIsEnabled", n -> this.setDisableAppEncryptionIfDeviceEncryptionIsEnabled(n.getBooleanValue()));
        deserializerMap.put("encryptAppData", n -> this.setEncryptAppData(n.getBooleanValue()));
        deserializerMap.put("minimumRequiredPatchVersion", n -> this.setMinimumRequiredPatchVersion(n.getStringValue()));
        deserializerMap.put("minimumWarningPatchVersion", n -> this.setMinimumWarningPatchVersion(n.getStringValue()));
        deserializerMap.put("screenCaptureBlocked", n -> this.setScreenCaptureBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMinimumRequiredPatchVersion() {
        return (String)this.backingStore.get("minimumRequiredPatchVersion");
    }

    @Nullable
    public String getMinimumWarningPatchVersion() {
        return (String)this.backingStore.get("minimumWarningPatchVersion");
    }

    @Nullable
    public Boolean getScreenCaptureBlocked() {
        return (Boolean)this.backingStore.get("screenCaptureBlocked");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("apps", this.getApps());
        writer.writeStringValue("customBrowserDisplayName", this.getCustomBrowserDisplayName());
        writer.writeStringValue("customBrowserPackageId", this.getCustomBrowserPackageId());
        writer.writeIntegerValue("deployedAppCount", this.getDeployedAppCount());
        writer.writeObjectValue("deploymentSummary", (Parsable)this.getDeploymentSummary(), new Parsable[0]);
        writer.writeBooleanValue("disableAppEncryptionIfDeviceEncryptionIsEnabled", this.getDisableAppEncryptionIfDeviceEncryptionIsEnabled());
        writer.writeBooleanValue("encryptAppData", this.getEncryptAppData());
        writer.writeStringValue("minimumRequiredPatchVersion", this.getMinimumRequiredPatchVersion());
        writer.writeStringValue("minimumWarningPatchVersion", this.getMinimumWarningPatchVersion());
        writer.writeBooleanValue("screenCaptureBlocked", this.getScreenCaptureBlocked());
    }

    public void setApps(@Nullable List<ManagedMobileApp> value) {
        this.backingStore.set("apps", value);
    }

    public void setCustomBrowserDisplayName(@Nullable String value) {
        this.backingStore.set("customBrowserDisplayName", (Object)value);
    }

    public void setCustomBrowserPackageId(@Nullable String value) {
        this.backingStore.set("customBrowserPackageId", (Object)value);
    }

    public void setDeployedAppCount(@Nullable Integer value) {
        this.backingStore.set("deployedAppCount", (Object)value);
    }

    public void setDeploymentSummary(@Nullable ManagedAppPolicyDeploymentSummary value) {
        this.backingStore.set("deploymentSummary", (Object)value);
    }

    public void setDisableAppEncryptionIfDeviceEncryptionIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("disableAppEncryptionIfDeviceEncryptionIsEnabled", (Object)value);
    }

    public void setEncryptAppData(@Nullable Boolean value) {
        this.backingStore.set("encryptAppData", (Object)value);
    }

    public void setMinimumRequiredPatchVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredPatchVersion", (Object)value);
    }

    public void setMinimumWarningPatchVersion(@Nullable String value) {
        this.backingStore.set("minimumWarningPatchVersion", (Object)value);
    }

    public void setScreenCaptureBlocked(@Nullable Boolean value) {
        this.backingStore.set("screenCaptureBlocked", (Object)value);
    }
}

