/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingCustomerInformationBase;
import com.microsoft.graph.models.BookingQuestionAnswer;
import com.microsoft.graph.models.Location;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingCustomerInformation
extends BookingCustomerInformationBase
implements Parsable {
    public BookingCustomerInformation() {
        this.setOdataType("#microsoft.graph.bookingCustomerInformation");
    }

    @Nonnull
    public static BookingCustomerInformation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingCustomerInformation();
    }

    @Nullable
    public String getCustomerId() {
        return (String)this.backingStore.get("customerId");
    }

    @Nullable
    public List<BookingQuestionAnswer> getCustomQuestionAnswers() {
        return (List)this.backingStore.get("customQuestionAnswers");
    }

    @Nullable
    public String getEmailAddress() {
        return (String)this.backingStore.get("emailAddress");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("customerId", n -> this.setCustomerId(n.getStringValue()));
        deserializerMap.put("customQuestionAnswers", n -> this.setCustomQuestionAnswers(n.getCollectionOfObjectValues(BookingQuestionAnswer::createFromDiscriminatorValue)));
        deserializerMap.put("emailAddress", n -> this.setEmailAddress(n.getStringValue()));
        deserializerMap.put("location", n -> this.setLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("notes", n -> this.setNotes(n.getStringValue()));
        deserializerMap.put("phone", n -> this.setPhone(n.getStringValue()));
        deserializerMap.put("timeZone", n -> this.setTimeZone(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Location getLocation() {
        return (Location)this.backingStore.get("location");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getNotes() {
        return (String)this.backingStore.get("notes");
    }

    @Nullable
    public String getPhone() {
        return (String)this.backingStore.get("phone");
    }

    @Nullable
    public String getTimeZone() {
        return (String)this.backingStore.get("timeZone");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("customerId", this.getCustomerId());
        writer.writeCollectionOfObjectValues("customQuestionAnswers", this.getCustomQuestionAnswers());
        writer.writeStringValue("emailAddress", this.getEmailAddress());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("notes", this.getNotes());
        writer.writeStringValue("phone", this.getPhone());
        writer.writeStringValue("timeZone", this.getTimeZone());
    }

    public void setCustomerId(@Nullable String value) {
        this.backingStore.set("customerId", (Object)value);
    }

    public void setCustomQuestionAnswers(@Nullable List<BookingQuestionAnswer> value) {
        this.backingStore.set("customQuestionAnswers", value);
    }

    public void setEmailAddress(@Nullable String value) {
        this.backingStore.set("emailAddress", (Object)value);
    }

    public void setLocation(@Nullable Location value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setNotes(@Nullable String value) {
        this.backingStore.set("notes", (Object)value);
    }

    public void setPhone(@Nullable String value) {
        this.backingStore.set("phone", (Object)value);
    }

    public void setTimeZone(@Nullable String value) {
        this.backingStore.set("timeZone", (Object)value);
    }
}

