/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingPriceType;
import com.microsoft.graph.models.BookingQuestionAssignment;
import com.microsoft.graph.models.BookingReminder;
import com.microsoft.graph.models.BookingSchedulingPolicy;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Location;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingService
extends Entity
implements Parsable {
    @Nonnull
    public static BookingService createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingService();
    }

    @Nullable
    public String getAdditionalInformation() {
        return (String)this.backingStore.get("additionalInformation");
    }

    @Nullable
    public List<BookingQuestionAssignment> getCustomQuestions() {
        return (List)this.backingStore.get("customQuestions");
    }

    @Nullable
    public PeriodAndDuration getDefaultDuration() {
        return (PeriodAndDuration)this.backingStore.get("defaultDuration");
    }

    @Nullable
    public Location getDefaultLocation() {
        return (Location)this.backingStore.get("defaultLocation");
    }

    @Nullable
    public Double getDefaultPrice() {
        return (Double)this.backingStore.get("defaultPrice");
    }

    @Nullable
    public BookingPriceType getDefaultPriceType() {
        return (BookingPriceType)((Object)this.backingStore.get("defaultPriceType"));
    }

    @Nullable
    public List<BookingReminder> getDefaultReminders() {
        return (List)this.backingStore.get("defaultReminders");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalInformation", n -> this.setAdditionalInformation(n.getStringValue()));
        deserializerMap.put("customQuestions", n -> this.setCustomQuestions(n.getCollectionOfObjectValues(BookingQuestionAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("defaultDuration", n -> this.setDefaultDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("defaultLocation", n -> this.setDefaultLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("defaultPrice", n -> this.setDefaultPrice(n.getDoubleValue()));
        deserializerMap.put("defaultPriceType", n -> this.setDefaultPriceType((BookingPriceType)n.getEnumValue(BookingPriceType::forValue)));
        deserializerMap.put("defaultReminders", n -> this.setDefaultReminders(n.getCollectionOfObjectValues(BookingReminder::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isAnonymousJoinEnabled", n -> this.setIsAnonymousJoinEnabled(n.getBooleanValue()));
        deserializerMap.put("isHiddenFromCustomers", n -> this.setIsHiddenFromCustomers(n.getBooleanValue()));
        deserializerMap.put("isLocationOnline", n -> this.setIsLocationOnline(n.getBooleanValue()));
        deserializerMap.put("languageTag", n -> this.setLanguageTag(n.getStringValue()));
        deserializerMap.put("maximumAttendeesCount", n -> this.setMaximumAttendeesCount(n.getIntegerValue()));
        deserializerMap.put("notes", n -> this.setNotes(n.getStringValue()));
        deserializerMap.put("postBuffer", n -> this.setPostBuffer(n.getPeriodAndDurationValue()));
        deserializerMap.put("preBuffer", n -> this.setPreBuffer(n.getPeriodAndDurationValue()));
        deserializerMap.put("schedulingPolicy", n -> this.setSchedulingPolicy((BookingSchedulingPolicy)n.getObjectValue(BookingSchedulingPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("smsNotificationsEnabled", n -> this.setSmsNotificationsEnabled(n.getBooleanValue()));
        deserializerMap.put("staffMemberIds", n -> this.setStaffMemberIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAnonymousJoinEnabled() {
        return (Boolean)this.backingStore.get("isAnonymousJoinEnabled");
    }

    @Nullable
    public Boolean getIsHiddenFromCustomers() {
        return (Boolean)this.backingStore.get("isHiddenFromCustomers");
    }

    @Nullable
    public Boolean getIsLocationOnline() {
        return (Boolean)this.backingStore.get("isLocationOnline");
    }

    @Nullable
    public String getLanguageTag() {
        return (String)this.backingStore.get("languageTag");
    }

    @Nullable
    public Integer getMaximumAttendeesCount() {
        return (Integer)this.backingStore.get("maximumAttendeesCount");
    }

    @Nullable
    public String getNotes() {
        return (String)this.backingStore.get("notes");
    }

    @Nullable
    public PeriodAndDuration getPostBuffer() {
        return (PeriodAndDuration)this.backingStore.get("postBuffer");
    }

    @Nullable
    public PeriodAndDuration getPreBuffer() {
        return (PeriodAndDuration)this.backingStore.get("preBuffer");
    }

    @Nullable
    public BookingSchedulingPolicy getSchedulingPolicy() {
        return (BookingSchedulingPolicy)this.backingStore.get("schedulingPolicy");
    }

    @Nullable
    public Boolean getSmsNotificationsEnabled() {
        return (Boolean)this.backingStore.get("smsNotificationsEnabled");
    }

    @Nullable
    public List<String> getStaffMemberIds() {
        return (List)this.backingStore.get("staffMemberIds");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("additionalInformation", this.getAdditionalInformation());
        writer.writeCollectionOfObjectValues("customQuestions", this.getCustomQuestions());
        writer.writePeriodAndDurationValue("defaultDuration", this.getDefaultDuration());
        writer.writeObjectValue("defaultLocation", (Parsable)this.getDefaultLocation(), new Parsable[0]);
        writer.writeDoubleValue("defaultPrice", this.getDefaultPrice());
        writer.writeEnumValue("defaultPriceType", (Enum)this.getDefaultPriceType());
        writer.writeCollectionOfObjectValues("defaultReminders", this.getDefaultReminders());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isAnonymousJoinEnabled", this.getIsAnonymousJoinEnabled());
        writer.writeBooleanValue("isHiddenFromCustomers", this.getIsHiddenFromCustomers());
        writer.writeBooleanValue("isLocationOnline", this.getIsLocationOnline());
        writer.writeStringValue("languageTag", this.getLanguageTag());
        writer.writeIntegerValue("maximumAttendeesCount", this.getMaximumAttendeesCount());
        writer.writeStringValue("notes", this.getNotes());
        writer.writePeriodAndDurationValue("postBuffer", this.getPostBuffer());
        writer.writePeriodAndDurationValue("preBuffer", this.getPreBuffer());
        writer.writeObjectValue("schedulingPolicy", (Parsable)this.getSchedulingPolicy(), new Parsable[0]);
        writer.writeBooleanValue("smsNotificationsEnabled", this.getSmsNotificationsEnabled());
        writer.writeCollectionOfPrimitiveValues("staffMemberIds", this.getStaffMemberIds());
    }

    public void setAdditionalInformation(@Nullable String value) {
        this.backingStore.set("additionalInformation", (Object)value);
    }

    public void setCustomQuestions(@Nullable List<BookingQuestionAssignment> value) {
        this.backingStore.set("customQuestions", value);
    }

    public void setDefaultDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("defaultDuration", (Object)value);
    }

    public void setDefaultLocation(@Nullable Location value) {
        this.backingStore.set("defaultLocation", (Object)value);
    }

    public void setDefaultPrice(@Nullable Double value) {
        this.backingStore.set("defaultPrice", (Object)value);
    }

    public void setDefaultPriceType(@Nullable BookingPriceType value) {
        this.backingStore.set("defaultPriceType", (Object)value);
    }

    public void setDefaultReminders(@Nullable List<BookingReminder> value) {
        this.backingStore.set("defaultReminders", value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsAnonymousJoinEnabled(@Nullable Boolean value) {
        this.backingStore.set("isAnonymousJoinEnabled", (Object)value);
    }

    public void setIsHiddenFromCustomers(@Nullable Boolean value) {
        this.backingStore.set("isHiddenFromCustomers", (Object)value);
    }

    public void setIsLocationOnline(@Nullable Boolean value) {
        this.backingStore.set("isLocationOnline", (Object)value);
    }

    public void setLanguageTag(@Nullable String value) {
        this.backingStore.set("languageTag", (Object)value);
    }

    public void setMaximumAttendeesCount(@Nullable Integer value) {
        this.backingStore.set("maximumAttendeesCount", (Object)value);
    }

    public void setNotes(@Nullable String value) {
        this.backingStore.set("notes", (Object)value);
    }

    public void setPostBuffer(@Nullable PeriodAndDuration value) {
        this.backingStore.set("postBuffer", (Object)value);
    }

    public void setPreBuffer(@Nullable PeriodAndDuration value) {
        this.backingStore.set("preBuffer", (Object)value);
    }

    public void setSchedulingPolicy(@Nullable BookingSchedulingPolicy value) {
        this.backingStore.set("schedulingPolicy", (Object)value);
    }

    public void setSmsNotificationsEnabled(@Nullable Boolean value) {
        this.backingStore.set("smsNotificationsEnabled", (Object)value);
    }

    public void setStaffMemberIds(@Nullable List<String> value) {
        this.backingStore.set("staffMemberIds", value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

