/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChatMessageActions;
import com.microsoft.graph.models.ChatMessageReaction;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ChatMessageHistoryItem
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ChatMessageHistoryItem() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ChatMessageHistoryItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ChatMessageHistoryItem();
    }

    @Nullable
    public EnumSet<ChatMessageActions> getActions() {
        return (EnumSet)this.backingStore.get("actions");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("actions", n -> this.setActions(n.getEnumSetValue(ChatMessageActions::forValue)));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("reaction", n -> this.setReaction((ChatMessageReaction)n.getObjectValue(ChatMessageReaction::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ChatMessageReaction getReaction() {
        return (ChatMessageReaction)this.backingStore.get("reaction");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumSetValue("actions", this.getActions());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("reaction", (Parsable)this.getReaction(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActions(@Nullable EnumSet<ChatMessageActions> value) {
        this.backingStore.set("actions", value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReaction(@Nullable ChatMessageReaction value) {
        this.backingStore.set("reaction", (Object)value);
    }
}

