/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ConditionalAccessFilter;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConditionalAccessApplications
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ConditionalAccessApplications() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ConditionalAccessApplications createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ConditionalAccessApplications();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public ConditionalAccessFilter getApplicationFilter() {
        return (ConditionalAccessFilter)this.backingStore.get("applicationFilter");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<String> getExcludeApplications() {
        return (List)this.backingStore.get("excludeApplications");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("applicationFilter", n -> this.setApplicationFilter((ConditionalAccessFilter)n.getObjectValue(ConditionalAccessFilter::createFromDiscriminatorValue)));
        deserializerMap.put("excludeApplications", n -> this.setExcludeApplications(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("includeApplications", n -> this.setIncludeApplications(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("includeAuthenticationContextClassReferences", n -> this.setIncludeAuthenticationContextClassReferences(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("includeUserActions", n -> this.setIncludeUserActions(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<String> getIncludeApplications() {
        return (List)this.backingStore.get("includeApplications");
    }

    @Nullable
    public List<String> getIncludeAuthenticationContextClassReferences() {
        return (List)this.backingStore.get("includeAuthenticationContextClassReferences");
    }

    @Nullable
    public List<String> getIncludeUserActions() {
        return (List)this.backingStore.get("includeUserActions");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("applicationFilter", (Parsable)this.getApplicationFilter(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("excludeApplications", this.getExcludeApplications());
        writer.writeCollectionOfPrimitiveValues("includeApplications", this.getIncludeApplications());
        writer.writeCollectionOfPrimitiveValues("includeAuthenticationContextClassReferences", this.getIncludeAuthenticationContextClassReferences());
        writer.writeCollectionOfPrimitiveValues("includeUserActions", this.getIncludeUserActions());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplicationFilter(@Nullable ConditionalAccessFilter value) {
        this.backingStore.set("applicationFilter", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExcludeApplications(@Nullable List<String> value) {
        this.backingStore.set("excludeApplications", value);
    }

    public void setIncludeApplications(@Nullable List<String> value) {
        this.backingStore.set("includeApplications", value);
    }

    public void setIncludeAuthenticationContextClassReferences(@Nullable List<String> value) {
        this.backingStore.set("includeAuthenticationContextClassReferences", value);
    }

    public void setIncludeUserActions(@Nullable List<String> value) {
        this.backingStore.set("includeUserActions", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

