/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceHealthAttestationState
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceHealthAttestationState() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceHealthAttestationState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceHealthAttestationState();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAttestationIdentityKey() {
        return (String)this.backingStore.get("attestationIdentityKey");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getBitLockerStatus() {
        return (String)this.backingStore.get("bitLockerStatus");
    }

    @Nullable
    public String getBootAppSecurityVersion() {
        return (String)this.backingStore.get("bootAppSecurityVersion");
    }

    @Nullable
    public String getBootDebugging() {
        return (String)this.backingStore.get("bootDebugging");
    }

    @Nullable
    public String getBootManagerSecurityVersion() {
        return (String)this.backingStore.get("bootManagerSecurityVersion");
    }

    @Nullable
    public String getBootManagerVersion() {
        return (String)this.backingStore.get("bootManagerVersion");
    }

    @Nullable
    public String getBootRevisionListInfo() {
        return (String)this.backingStore.get("bootRevisionListInfo");
    }

    @Nullable
    public String getCodeIntegrity() {
        return (String)this.backingStore.get("codeIntegrity");
    }

    @Nullable
    public String getCodeIntegrityCheckVersion() {
        return (String)this.backingStore.get("codeIntegrityCheckVersion");
    }

    @Nullable
    public String getCodeIntegrityPolicy() {
        return (String)this.backingStore.get("codeIntegrityPolicy");
    }

    @Nullable
    public String getContentNamespaceUrl() {
        return (String)this.backingStore.get("contentNamespaceUrl");
    }

    @Nullable
    public String getContentVersion() {
        return (String)this.backingStore.get("contentVersion");
    }

    @Nullable
    public String getDataExcutionPolicy() {
        return (String)this.backingStore.get("dataExcutionPolicy");
    }

    @Nullable
    public String getDeviceHealthAttestationStatus() {
        return (String)this.backingStore.get("deviceHealthAttestationStatus");
    }

    @Nullable
    public String getEarlyLaunchAntiMalwareDriverProtection() {
        return (String)this.backingStore.get("earlyLaunchAntiMalwareDriverProtection");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(33);
        deserializerMap.put("attestationIdentityKey", n -> this.setAttestationIdentityKey(n.getStringValue()));
        deserializerMap.put("bitLockerStatus", n -> this.setBitLockerStatus(n.getStringValue()));
        deserializerMap.put("bootAppSecurityVersion", n -> this.setBootAppSecurityVersion(n.getStringValue()));
        deserializerMap.put("bootDebugging", n -> this.setBootDebugging(n.getStringValue()));
        deserializerMap.put("bootManagerSecurityVersion", n -> this.setBootManagerSecurityVersion(n.getStringValue()));
        deserializerMap.put("bootManagerVersion", n -> this.setBootManagerVersion(n.getStringValue()));
        deserializerMap.put("bootRevisionListInfo", n -> this.setBootRevisionListInfo(n.getStringValue()));
        deserializerMap.put("codeIntegrity", n -> this.setCodeIntegrity(n.getStringValue()));
        deserializerMap.put("codeIntegrityCheckVersion", n -> this.setCodeIntegrityCheckVersion(n.getStringValue()));
        deserializerMap.put("codeIntegrityPolicy", n -> this.setCodeIntegrityPolicy(n.getStringValue()));
        deserializerMap.put("contentNamespaceUrl", n -> this.setContentNamespaceUrl(n.getStringValue()));
        deserializerMap.put("contentVersion", n -> this.setContentVersion(n.getStringValue()));
        deserializerMap.put("dataExcutionPolicy", n -> this.setDataExcutionPolicy(n.getStringValue()));
        deserializerMap.put("deviceHealthAttestationStatus", n -> this.setDeviceHealthAttestationStatus(n.getStringValue()));
        deserializerMap.put("earlyLaunchAntiMalwareDriverProtection", n -> this.setEarlyLaunchAntiMalwareDriverProtection(n.getStringValue()));
        deserializerMap.put("healthAttestationSupportedStatus", n -> this.setHealthAttestationSupportedStatus(n.getStringValue()));
        deserializerMap.put("healthStatusMismatchInfo", n -> this.setHealthStatusMismatchInfo(n.getStringValue()));
        deserializerMap.put("issuedDateTime", n -> this.setIssuedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operatingSystemKernelDebugging", n -> this.setOperatingSystemKernelDebugging(n.getStringValue()));
        deserializerMap.put("operatingSystemRevListInfo", n -> this.setOperatingSystemRevListInfo(n.getStringValue()));
        deserializerMap.put("pcr0", n -> this.setPcr0(n.getStringValue()));
        deserializerMap.put("pcrHashAlgorithm", n -> this.setPcrHashAlgorithm(n.getStringValue()));
        deserializerMap.put("resetCount", n -> this.setResetCount(n.getLongValue()));
        deserializerMap.put("restartCount", n -> this.setRestartCount(n.getLongValue()));
        deserializerMap.put("safeMode", n -> this.setSafeMode(n.getStringValue()));
        deserializerMap.put("secureBoot", n -> this.setSecureBoot(n.getStringValue()));
        deserializerMap.put("secureBootConfigurationPolicyFingerPrint", n -> this.setSecureBootConfigurationPolicyFingerPrint(n.getStringValue()));
        deserializerMap.put("testSigning", n -> this.setTestSigning(n.getStringValue()));
        deserializerMap.put("tpmVersion", n -> this.setTpmVersion(n.getStringValue()));
        deserializerMap.put("virtualSecureMode", n -> this.setVirtualSecureMode(n.getStringValue()));
        deserializerMap.put("windowsPE", n -> this.setWindowsPE(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getHealthAttestationSupportedStatus() {
        return (String)this.backingStore.get("healthAttestationSupportedStatus");
    }

    @Nullable
    public String getHealthStatusMismatchInfo() {
        return (String)this.backingStore.get("healthStatusMismatchInfo");
    }

    @Nullable
    public OffsetDateTime getIssuedDateTime() {
        return (OffsetDateTime)this.backingStore.get("issuedDateTime");
    }

    @Nullable
    public String getLastUpdateDateTime() {
        return (String)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOperatingSystemKernelDebugging() {
        return (String)this.backingStore.get("operatingSystemKernelDebugging");
    }

    @Nullable
    public String getOperatingSystemRevListInfo() {
        return (String)this.backingStore.get("operatingSystemRevListInfo");
    }

    @Nullable
    public String getPcr0() {
        return (String)this.backingStore.get("pcr0");
    }

    @Nullable
    public String getPcrHashAlgorithm() {
        return (String)this.backingStore.get("pcrHashAlgorithm");
    }

    @Nullable
    public Long getResetCount() {
        return (Long)this.backingStore.get("resetCount");
    }

    @Nullable
    public Long getRestartCount() {
        return (Long)this.backingStore.get("restartCount");
    }

    @Nullable
    public String getSafeMode() {
        return (String)this.backingStore.get("safeMode");
    }

    @Nullable
    public String getSecureBoot() {
        return (String)this.backingStore.get("secureBoot");
    }

    @Nullable
    public String getSecureBootConfigurationPolicyFingerPrint() {
        return (String)this.backingStore.get("secureBootConfigurationPolicyFingerPrint");
    }

    @Nullable
    public String getTestSigning() {
        return (String)this.backingStore.get("testSigning");
    }

    @Nullable
    public String getTpmVersion() {
        return (String)this.backingStore.get("tpmVersion");
    }

    @Nullable
    public String getVirtualSecureMode() {
        return (String)this.backingStore.get("virtualSecureMode");
    }

    @Nullable
    public String getWindowsPE() {
        return (String)this.backingStore.get("windowsPE");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("attestationIdentityKey", this.getAttestationIdentityKey());
        writer.writeStringValue("bitLockerStatus", this.getBitLockerStatus());
        writer.writeStringValue("bootAppSecurityVersion", this.getBootAppSecurityVersion());
        writer.writeStringValue("bootDebugging", this.getBootDebugging());
        writer.writeStringValue("bootManagerSecurityVersion", this.getBootManagerSecurityVersion());
        writer.writeStringValue("bootManagerVersion", this.getBootManagerVersion());
        writer.writeStringValue("bootRevisionListInfo", this.getBootRevisionListInfo());
        writer.writeStringValue("codeIntegrity", this.getCodeIntegrity());
        writer.writeStringValue("codeIntegrityCheckVersion", this.getCodeIntegrityCheckVersion());
        writer.writeStringValue("codeIntegrityPolicy", this.getCodeIntegrityPolicy());
        writer.writeStringValue("contentNamespaceUrl", this.getContentNamespaceUrl());
        writer.writeStringValue("contentVersion", this.getContentVersion());
        writer.writeStringValue("dataExcutionPolicy", this.getDataExcutionPolicy());
        writer.writeStringValue("deviceHealthAttestationStatus", this.getDeviceHealthAttestationStatus());
        writer.writeStringValue("earlyLaunchAntiMalwareDriverProtection", this.getEarlyLaunchAntiMalwareDriverProtection());
        writer.writeStringValue("healthAttestationSupportedStatus", this.getHealthAttestationSupportedStatus());
        writer.writeStringValue("healthStatusMismatchInfo", this.getHealthStatusMismatchInfo());
        writer.writeOffsetDateTimeValue("issuedDateTime", this.getIssuedDateTime());
        writer.writeStringValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("operatingSystemKernelDebugging", this.getOperatingSystemKernelDebugging());
        writer.writeStringValue("operatingSystemRevListInfo", this.getOperatingSystemRevListInfo());
        writer.writeStringValue("pcr0", this.getPcr0());
        writer.writeStringValue("pcrHashAlgorithm", this.getPcrHashAlgorithm());
        writer.writeLongValue("resetCount", this.getResetCount());
        writer.writeLongValue("restartCount", this.getRestartCount());
        writer.writeStringValue("safeMode", this.getSafeMode());
        writer.writeStringValue("secureBoot", this.getSecureBoot());
        writer.writeStringValue("secureBootConfigurationPolicyFingerPrint", this.getSecureBootConfigurationPolicyFingerPrint());
        writer.writeStringValue("testSigning", this.getTestSigning());
        writer.writeStringValue("tpmVersion", this.getTpmVersion());
        writer.writeStringValue("virtualSecureMode", this.getVirtualSecureMode());
        writer.writeStringValue("windowsPE", this.getWindowsPE());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAttestationIdentityKey(@Nullable String value) {
        this.backingStore.set("attestationIdentityKey", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBitLockerStatus(@Nullable String value) {
        this.backingStore.set("bitLockerStatus", (Object)value);
    }

    public void setBootAppSecurityVersion(@Nullable String value) {
        this.backingStore.set("bootAppSecurityVersion", (Object)value);
    }

    public void setBootDebugging(@Nullable String value) {
        this.backingStore.set("bootDebugging", (Object)value);
    }

    public void setBootManagerSecurityVersion(@Nullable String value) {
        this.backingStore.set("bootManagerSecurityVersion", (Object)value);
    }

    public void setBootManagerVersion(@Nullable String value) {
        this.backingStore.set("bootManagerVersion", (Object)value);
    }

    public void setBootRevisionListInfo(@Nullable String value) {
        this.backingStore.set("bootRevisionListInfo", (Object)value);
    }

    public void setCodeIntegrity(@Nullable String value) {
        this.backingStore.set("codeIntegrity", (Object)value);
    }

    public void setCodeIntegrityCheckVersion(@Nullable String value) {
        this.backingStore.set("codeIntegrityCheckVersion", (Object)value);
    }

    public void setCodeIntegrityPolicy(@Nullable String value) {
        this.backingStore.set("codeIntegrityPolicy", (Object)value);
    }

    public void setContentNamespaceUrl(@Nullable String value) {
        this.backingStore.set("contentNamespaceUrl", (Object)value);
    }

    public void setContentVersion(@Nullable String value) {
        this.backingStore.set("contentVersion", (Object)value);
    }

    public void setDataExcutionPolicy(@Nullable String value) {
        this.backingStore.set("dataExcutionPolicy", (Object)value);
    }

    public void setDeviceHealthAttestationStatus(@Nullable String value) {
        this.backingStore.set("deviceHealthAttestationStatus", (Object)value);
    }

    public void setEarlyLaunchAntiMalwareDriverProtection(@Nullable String value) {
        this.backingStore.set("earlyLaunchAntiMalwareDriverProtection", (Object)value);
    }

    public void setHealthAttestationSupportedStatus(@Nullable String value) {
        this.backingStore.set("healthAttestationSupportedStatus", (Object)value);
    }

    public void setHealthStatusMismatchInfo(@Nullable String value) {
        this.backingStore.set("healthStatusMismatchInfo", (Object)value);
    }

    public void setIssuedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("issuedDateTime", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable String value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperatingSystemKernelDebugging(@Nullable String value) {
        this.backingStore.set("operatingSystemKernelDebugging", (Object)value);
    }

    public void setOperatingSystemRevListInfo(@Nullable String value) {
        this.backingStore.set("operatingSystemRevListInfo", (Object)value);
    }

    public void setPcr0(@Nullable String value) {
        this.backingStore.set("pcr0", (Object)value);
    }

    public void setPcrHashAlgorithm(@Nullable String value) {
        this.backingStore.set("pcrHashAlgorithm", (Object)value);
    }

    public void setResetCount(@Nullable Long value) {
        this.backingStore.set("resetCount", (Object)value);
    }

    public void setRestartCount(@Nullable Long value) {
        this.backingStore.set("restartCount", (Object)value);
    }

    public void setSafeMode(@Nullable String value) {
        this.backingStore.set("safeMode", (Object)value);
    }

    public void setSecureBoot(@Nullable String value) {
        this.backingStore.set("secureBoot", (Object)value);
    }

    public void setSecureBootConfigurationPolicyFingerPrint(@Nullable String value) {
        this.backingStore.set("secureBootConfigurationPolicyFingerPrint", (Object)value);
    }

    public void setTestSigning(@Nullable String value) {
        this.backingStore.set("testSigning", (Object)value);
    }

    public void setTpmVersion(@Nullable String value) {
        this.backingStore.set("tpmVersion", (Object)value);
    }

    public void setVirtualSecureMode(@Nullable String value) {
        this.backingStore.set("virtualSecureMode", (Object)value);
    }

    public void setWindowsPE(@Nullable String value) {
        this.backingStore.set("windowsPE", (Object)value);
    }
}

