/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ScopedRoleMembership;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DirectoryRole
extends DirectoryObject
implements Parsable {
    public DirectoryRole() {
        this.setOdataType("#microsoft.graph.directoryRole");
    }

    @Nonnull
    public static DirectoryRole createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DirectoryRole();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("roleTemplateId", n -> this.setRoleTemplateId(n.getStringValue()));
        deserializerMap.put("scopedMembers", n -> this.setScopedMembers(n.getCollectionOfObjectValues(ScopedRoleMembership::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<DirectoryObject> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public String getRoleTemplateId() {
        return (String)this.backingStore.get("roleTemplateId");
    }

    @Nullable
    public List<ScopedRoleMembership> getScopedMembers() {
        return (List)this.backingStore.get("scopedMembers");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeStringValue("roleTemplateId", this.getRoleTemplateId());
        writer.writeCollectionOfObjectValues("scopedMembers", this.getScopedMembers());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setMembers(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("members", value);
    }

    public void setRoleTemplateId(@Nullable String value) {
        this.backingStore.set("roleTemplateId", (Object)value);
    }

    public void setScopedMembers(@Nullable List<ScopedRoleMembership> value) {
        this.backingStore.set("scopedMembers", value);
    }
}

