/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AdministrativeUnit;
import com.microsoft.graph.models.EducationClass;
import com.microsoft.graph.models.EducationOrganization;
import com.microsoft.graph.models.EducationUser;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationSchool
extends EducationOrganization
implements Parsable {
    public EducationSchool() {
        this.setOdataType("#microsoft.graph.educationSchool");
    }

    @Nonnull
    public static EducationSchool createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationSchool();
    }

    @Nullable
    public PhysicalAddress getAddress() {
        return (PhysicalAddress)this.backingStore.get("address");
    }

    @Nullable
    public AdministrativeUnit getAdministrativeUnit() {
        return (AdministrativeUnit)this.backingStore.get("administrativeUnit");
    }

    @Nullable
    public List<EducationClass> getClasses() {
        return (List)this.backingStore.get("classes");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public String getExternalId() {
        return (String)this.backingStore.get("externalId");
    }

    @Nullable
    public String getExternalPrincipalId() {
        return (String)this.backingStore.get("externalPrincipalId");
    }

    @Nullable
    public String getFax() {
        return (String)this.backingStore.get("fax");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("address", n -> this.setAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("administrativeUnit", n -> this.setAdministrativeUnit((AdministrativeUnit)n.getObjectValue(AdministrativeUnit::createFromDiscriminatorValue)));
        deserializerMap.put("classes", n -> this.setClasses(n.getCollectionOfObjectValues(EducationClass::createFromDiscriminatorValue)));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("externalId", n -> this.setExternalId(n.getStringValue()));
        deserializerMap.put("externalPrincipalId", n -> this.setExternalPrincipalId(n.getStringValue()));
        deserializerMap.put("fax", n -> this.setFax(n.getStringValue()));
        deserializerMap.put("highestGrade", n -> this.setHighestGrade(n.getStringValue()));
        deserializerMap.put("lowestGrade", n -> this.setLowestGrade(n.getStringValue()));
        deserializerMap.put("phone", n -> this.setPhone(n.getStringValue()));
        deserializerMap.put("principalEmail", n -> this.setPrincipalEmail(n.getStringValue()));
        deserializerMap.put("principalName", n -> this.setPrincipalName(n.getStringValue()));
        deserializerMap.put("schoolNumber", n -> this.setSchoolNumber(n.getStringValue()));
        deserializerMap.put("users", n -> this.setUsers(n.getCollectionOfObjectValues(EducationUser::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getHighestGrade() {
        return (String)this.backingStore.get("highestGrade");
    }

    @Nullable
    public String getLowestGrade() {
        return (String)this.backingStore.get("lowestGrade");
    }

    @Nullable
    public String getPhone() {
        return (String)this.backingStore.get("phone");
    }

    @Nullable
    public String getPrincipalEmail() {
        return (String)this.backingStore.get("principalEmail");
    }

    @Nullable
    public String getPrincipalName() {
        return (String)this.backingStore.get("principalName");
    }

    @Nullable
    public String getSchoolNumber() {
        return (String)this.backingStore.get("schoolNumber");
    }

    @Nullable
    public List<EducationUser> getUsers() {
        return (List)this.backingStore.get("users");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("address", (Parsable)this.getAddress(), new Parsable[0]);
        writer.writeObjectValue("administrativeUnit", (Parsable)this.getAdministrativeUnit(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("classes", this.getClasses());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeStringValue("externalId", this.getExternalId());
        writer.writeStringValue("externalPrincipalId", this.getExternalPrincipalId());
        writer.writeStringValue("fax", this.getFax());
        writer.writeStringValue("highestGrade", this.getHighestGrade());
        writer.writeStringValue("lowestGrade", this.getLowestGrade());
        writer.writeStringValue("phone", this.getPhone());
        writer.writeStringValue("principalEmail", this.getPrincipalEmail());
        writer.writeStringValue("principalName", this.getPrincipalName());
        writer.writeStringValue("schoolNumber", this.getSchoolNumber());
        writer.writeCollectionOfObjectValues("users", this.getUsers());
    }

    public void setAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setAdministrativeUnit(@Nullable AdministrativeUnit value) {
        this.backingStore.set("administrativeUnit", (Object)value);
    }

    public void setClasses(@Nullable List<EducationClass> value) {
        this.backingStore.set("classes", value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setExternalId(@Nullable String value) {
        this.backingStore.set("externalId", (Object)value);
    }

    public void setExternalPrincipalId(@Nullable String value) {
        this.backingStore.set("externalPrincipalId", (Object)value);
    }

    public void setFax(@Nullable String value) {
        this.backingStore.set("fax", (Object)value);
    }

    public void setHighestGrade(@Nullable String value) {
        this.backingStore.set("highestGrade", (Object)value);
    }

    public void setLowestGrade(@Nullable String value) {
        this.backingStore.set("lowestGrade", (Object)value);
    }

    public void setPhone(@Nullable String value) {
        this.backingStore.set("phone", (Object)value);
    }

    public void setPrincipalEmail(@Nullable String value) {
        this.backingStore.set("principalEmail", (Object)value);
    }

    public void setPrincipalName(@Nullable String value) {
        this.backingStore.set("principalName", (Object)value);
    }

    public void setSchoolNumber(@Nullable String value) {
        this.backingStore.set("schoolNumber", (Object)value);
    }

    public void setUsers(@Nullable List<EducationUser> value) {
        this.backingStore.set("users", value);
    }
}

