/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.LocationConstraintItem;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class LocationConstraint
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public LocationConstraint() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static LocationConstraint createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new LocationConstraint();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("isRequired", n -> this.setIsRequired(n.getBooleanValue()));
        deserializerMap.put("locations", n -> this.setLocations(n.getCollectionOfObjectValues(LocationConstraintItem::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("suggestLocation", n -> this.setSuggestLocation(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsRequired() {
        return (Boolean)this.backingStore.get("isRequired");
    }

    @Nullable
    public List<LocationConstraintItem> getLocations() {
        return (List)this.backingStore.get("locations");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getSuggestLocation() {
        return (Boolean)this.backingStore.get("suggestLocation");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("isRequired", this.getIsRequired());
        writer.writeCollectionOfObjectValues("locations", this.getLocations());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("suggestLocation", this.getSuggestLocation());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsRequired(@Nullable Boolean value) {
        this.backingStore.set("isRequired", (Object)value);
    }

    public void setLocations(@Nullable List<LocationConstraintItem> value) {
        this.backingStore.set("locations", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSuggestLocation(@Nullable Boolean value) {
        this.backingStore.set("suggestLocation", (Object)value);
    }
}

