/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.TargetedManagedAppConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedAppConfiguration
extends ManagedAppPolicy
implements Parsable {
    public ManagedAppConfiguration() {
        this.setOdataType("#microsoft.graph.managedAppConfiguration");
    }

    @Nonnull
    public static ManagedAppConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.targetedManagedAppConfiguration": {
                    return new TargetedManagedAppConfiguration();
                }
            }
        }
        return new ManagedAppConfiguration();
    }

    @Nullable
    public List<KeyValuePair> getCustomSettings() {
        return (List)this.backingStore.get("customSettings");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("customSettings", n -> this.setCustomSettings(n.getCollectionOfObjectValues(KeyValuePair::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("customSettings", this.getCustomSettings());
    }

    public void setCustomSettings(@Nullable List<KeyValuePair> value) {
        this.backingStore.set("customSettings", value);
    }
}

