/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceInstallState;
import com.microsoft.graph.models.EBookInstallSummary;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IosVppEBook;
import com.microsoft.graph.models.ManagedEBookAssignment;
import com.microsoft.graph.models.MimeContent;
import com.microsoft.graph.models.UserInstallStateSummary;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedEBook
extends Entity
implements Parsable {
    @Nonnull
    public static ManagedEBook createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.iosVppEBook": {
                    return new IosVppEBook();
                }
            }
        }
        return new ManagedEBook();
    }

    @Nullable
    public List<ManagedEBookAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public List<DeviceInstallState> getDeviceStates() {
        return (List)this.backingStore.get("deviceStates");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(ManagedEBookAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("deviceStates", n -> this.setDeviceStates(n.getCollectionOfObjectValues(DeviceInstallState::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("informationUrl", n -> this.setInformationUrl(n.getStringValue()));
        deserializerMap.put("installSummary", n -> this.setInstallSummary((EBookInstallSummary)n.getObjectValue(EBookInstallSummary::createFromDiscriminatorValue)));
        deserializerMap.put("largeCover", n -> this.setLargeCover((MimeContent)n.getObjectValue(MimeContent::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("privacyInformationUrl", n -> this.setPrivacyInformationUrl(n.getStringValue()));
        deserializerMap.put("publishedDateTime", n -> this.setPublishedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("publisher", n -> this.setPublisher(n.getStringValue()));
        deserializerMap.put("userStateSummary", n -> this.setUserStateSummary(n.getCollectionOfObjectValues(UserInstallStateSummary::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getInformationUrl() {
        return (String)this.backingStore.get("informationUrl");
    }

    @Nullable
    public EBookInstallSummary getInstallSummary() {
        return (EBookInstallSummary)this.backingStore.get("installSummary");
    }

    @Nullable
    public MimeContent getLargeCover() {
        return (MimeContent)this.backingStore.get("largeCover");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getPrivacyInformationUrl() {
        return (String)this.backingStore.get("privacyInformationUrl");
    }

    @Nullable
    public OffsetDateTime getPublishedDateTime() {
        return (OffsetDateTime)this.backingStore.get("publishedDateTime");
    }

    @Nullable
    public String getPublisher() {
        return (String)this.backingStore.get("publisher");
    }

    @Nullable
    public List<UserInstallStateSummary> getUserStateSummary() {
        return (List)this.backingStore.get("userStateSummary");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfObjectValues("deviceStates", this.getDeviceStates());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("informationUrl", this.getInformationUrl());
        writer.writeObjectValue("installSummary", (Parsable)this.getInstallSummary(), new Parsable[0]);
        writer.writeObjectValue("largeCover", (Parsable)this.getLargeCover(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("privacyInformationUrl", this.getPrivacyInformationUrl());
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeStringValue("publisher", this.getPublisher());
        writer.writeCollectionOfObjectValues("userStateSummary", this.getUserStateSummary());
    }

    public void setAssignments(@Nullable List<ManagedEBookAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDeviceStates(@Nullable List<DeviceInstallState> value) {
        this.backingStore.set("deviceStates", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setInformationUrl(@Nullable String value) {
        this.backingStore.set("informationUrl", (Object)value);
    }

    public void setInstallSummary(@Nullable EBookInstallSummary value) {
        this.backingStore.set("installSummary", (Object)value);
    }

    public void setLargeCover(@Nullable MimeContent value) {
        this.backingStore.set("largeCover", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setPrivacyInformationUrl(@Nullable String value) {
        this.backingStore.set("privacyInformationUrl", (Object)value);
    }

    public void setPublishedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", (Object)value);
    }

    public void setPublisher(@Nullable String value) {
        this.backingStore.set("publisher", (Object)value);
    }

    public void setUserStateSummary(@Nullable List<UserInstallStateSummary> value) {
        this.backingStore.set("userStateSummary", value);
    }
}

