/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAndroidLobApp;
import com.microsoft.graph.models.ManagedApp;
import com.microsoft.graph.models.ManagedIOSLobApp;
import com.microsoft.graph.models.MobileAppContent;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedMobileLobApp
extends ManagedApp
implements Parsable {
    public ManagedMobileLobApp() {
        this.setOdataType("#microsoft.graph.managedMobileLobApp");
    }

    @Nonnull
    public static ManagedMobileLobApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.managedAndroidLobApp": {
                    return new ManagedAndroidLobApp();
                }
                case "#microsoft.graph.managedIOSLobApp": {
                    return new ManagedIOSLobApp();
                }
            }
        }
        return new ManagedMobileLobApp();
    }

    @Nullable
    public String getCommittedContentVersion() {
        return (String)this.backingStore.get("committedContentVersion");
    }

    @Nullable
    public List<MobileAppContent> getContentVersions() {
        return (List)this.backingStore.get("contentVersions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("committedContentVersion", n -> this.setCommittedContentVersion(n.getStringValue()));
        deserializerMap.put("contentVersions", n -> this.setContentVersions(n.getCollectionOfObjectValues(MobileAppContent::createFromDiscriminatorValue)));
        deserializerMap.put("fileName", n -> this.setFileName(n.getStringValue()));
        deserializerMap.put("size", n -> this.setSize(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public String getFileName() {
        return (String)this.backingStore.get("fileName");
    }

    @Nullable
    public Long getSize() {
        return (Long)this.backingStore.get("size");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("committedContentVersion", this.getCommittedContentVersion());
        writer.writeCollectionOfObjectValues("contentVersions", this.getContentVersions());
        writer.writeStringValue("fileName", this.getFileName());
        writer.writeLongValue("size", this.getSize());
    }

    public void setCommittedContentVersion(@Nullable String value) {
        this.backingStore.set("committedContentVersion", (Object)value);
    }

    public void setContentVersions(@Nullable List<MobileAppContent> value) {
        this.backingStore.set("contentVersions", value);
    }

    public void setFileName(@Nullable String value) {
        this.backingStore.set("fileName", (Object)value);
    }

    public void setSize(@Nullable Long value) {
        this.backingStore.set("size", (Object)value);
    }
}

