/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.CalendarSharingMessage;
import com.microsoft.graph.models.EventMessage;
import com.microsoft.graph.models.EventMessageRequest;
import com.microsoft.graph.models.EventMessageResponse;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.FollowupFlag;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.InferenceClassificationType;
import com.microsoft.graph.models.InternetMessageHeader;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.OutlookItem;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Message
extends OutlookItem
implements Parsable {
    public Message() {
        this.setOdataType("#microsoft.graph.message");
    }

    @Nonnull
    public static Message createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.calendarSharingMessage": {
                    return new CalendarSharingMessage();
                }
                case "#microsoft.graph.eventMessage": {
                    return new EventMessage();
                }
                case "#microsoft.graph.eventMessageRequest": {
                    return new EventMessageRequest();
                }
                case "#microsoft.graph.eventMessageResponse": {
                    return new EventMessageResponse();
                }
            }
        }
        return new Message();
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public List<Recipient> getBccRecipients() {
        return (List)this.backingStore.get("bccRecipients");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public String getBodyPreview() {
        return (String)this.backingStore.get("bodyPreview");
    }

    @Nullable
    public List<Recipient> getCcRecipients() {
        return (List)this.backingStore.get("ccRecipients");
    }

    @Nullable
    public String getConversationId() {
        return (String)this.backingStore.get("conversationId");
    }

    @Nullable
    public byte[] getConversationIndex() {
        return (byte[])this.backingStore.get("conversationIndex");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(Attachment::createFromDiscriminatorValue)));
        deserializerMap.put("bccRecipients", n -> this.setBccRecipients(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("bodyPreview", n -> this.setBodyPreview(n.getStringValue()));
        deserializerMap.put("ccRecipients", n -> this.setCcRecipients(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("conversationId", n -> this.setConversationId(n.getStringValue()));
        deserializerMap.put("conversationIndex", n -> this.setConversationIndex(n.getByteArrayValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("flag", n -> this.setFlag((FollowupFlag)n.getObjectValue(FollowupFlag::createFromDiscriminatorValue)));
        deserializerMap.put("from", n -> this.setFrom((Recipient)n.getObjectValue(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("importance", n -> this.setImportance((Importance)n.getEnumValue(Importance::forValue)));
        deserializerMap.put("inferenceClassification", n -> this.setInferenceClassification((InferenceClassificationType)n.getEnumValue(InferenceClassificationType::forValue)));
        deserializerMap.put("internetMessageHeaders", n -> this.setInternetMessageHeaders(n.getCollectionOfObjectValues(InternetMessageHeader::createFromDiscriminatorValue)));
        deserializerMap.put("internetMessageId", n -> this.setInternetMessageId(n.getStringValue()));
        deserializerMap.put("isDeliveryReceiptRequested", n -> this.setIsDeliveryReceiptRequested(n.getBooleanValue()));
        deserializerMap.put("isDraft", n -> this.setIsDraft(n.getBooleanValue()));
        deserializerMap.put("isRead", n -> this.setIsRead(n.getBooleanValue()));
        deserializerMap.put("isReadReceiptRequested", n -> this.setIsReadReceiptRequested(n.getBooleanValue()));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("parentFolderId", n -> this.setParentFolderId(n.getStringValue()));
        deserializerMap.put("receivedDateTime", n -> this.setReceivedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("replyTo", n -> this.setReplyTo(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("sender", n -> this.setSender((Recipient)n.getObjectValue(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("sentDateTime", n -> this.setSentDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("toRecipients", n -> this.setToRecipients(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("uniqueBody", n -> this.setUniqueBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("webLink", n -> this.setWebLink(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public FollowupFlag getFlag() {
        return (FollowupFlag)this.backingStore.get("flag");
    }

    @Nullable
    public Recipient getFrom() {
        return (Recipient)this.backingStore.get("from");
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public Importance getImportance() {
        return (Importance)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public InferenceClassificationType getInferenceClassification() {
        return (InferenceClassificationType)((Object)this.backingStore.get("inferenceClassification"));
    }

    @Nullable
    public List<InternetMessageHeader> getInternetMessageHeaders() {
        return (List)this.backingStore.get("internetMessageHeaders");
    }

    @Nullable
    public String getInternetMessageId() {
        return (String)this.backingStore.get("internetMessageId");
    }

    @Nullable
    public Boolean getIsDeliveryReceiptRequested() {
        return (Boolean)this.backingStore.get("isDeliveryReceiptRequested");
    }

    @Nullable
    public Boolean getIsDraft() {
        return (Boolean)this.backingStore.get("isDraft");
    }

    @Nullable
    public Boolean getIsRead() {
        return (Boolean)this.backingStore.get("isRead");
    }

    @Nullable
    public Boolean getIsReadReceiptRequested() {
        return (Boolean)this.backingStore.get("isReadReceiptRequested");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public String getParentFolderId() {
        return (String)this.backingStore.get("parentFolderId");
    }

    @Nullable
    public OffsetDateTime getReceivedDateTime() {
        return (OffsetDateTime)this.backingStore.get("receivedDateTime");
    }

    @Nullable
    public List<Recipient> getReplyTo() {
        return (List)this.backingStore.get("replyTo");
    }

    @Nullable
    public Recipient getSender() {
        return (Recipient)this.backingStore.get("sender");
    }

    @Nullable
    public OffsetDateTime getSentDateTime() {
        return (OffsetDateTime)this.backingStore.get("sentDateTime");
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public List<Recipient> getToRecipients() {
        return (List)this.backingStore.get("toRecipients");
    }

    @Nullable
    public ItemBody getUniqueBody() {
        return (ItemBody)this.backingStore.get("uniqueBody");
    }

    @Nullable
    public String getWebLink() {
        return (String)this.backingStore.get("webLink");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeCollectionOfObjectValues("bccRecipients", this.getBccRecipients());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeStringValue("bodyPreview", this.getBodyPreview());
        writer.writeCollectionOfObjectValues("ccRecipients", this.getCcRecipients());
        writer.writeStringValue("conversationId", this.getConversationId());
        writer.writeByteArrayValue("conversationIndex", this.getConversationIndex());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeObjectValue("flag", (Parsable)this.getFlag(), new Parsable[0]);
        writer.writeObjectValue("from", (Parsable)this.getFrom(), new Parsable[0]);
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeEnumValue("inferenceClassification", (Enum)this.getInferenceClassification());
        writer.writeCollectionOfObjectValues("internetMessageHeaders", this.getInternetMessageHeaders());
        writer.writeStringValue("internetMessageId", this.getInternetMessageId());
        writer.writeBooleanValue("isDeliveryReceiptRequested", this.getIsDeliveryReceiptRequested());
        writer.writeBooleanValue("isDraft", this.getIsDraft());
        writer.writeBooleanValue("isRead", this.getIsRead());
        writer.writeBooleanValue("isReadReceiptRequested", this.getIsReadReceiptRequested());
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeStringValue("parentFolderId", this.getParentFolderId());
        writer.writeOffsetDateTimeValue("receivedDateTime", this.getReceivedDateTime());
        writer.writeCollectionOfObjectValues("replyTo", this.getReplyTo());
        writer.writeObjectValue("sender", (Parsable)this.getSender(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("sentDateTime", this.getSentDateTime());
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeCollectionOfObjectValues("toRecipients", this.getToRecipients());
        writer.writeObjectValue("uniqueBody", (Parsable)this.getUniqueBody(), new Parsable[0]);
        writer.writeStringValue("webLink", this.getWebLink());
    }

    public void setAttachments(@Nullable List<Attachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setBccRecipients(@Nullable List<Recipient> value) {
        this.backingStore.set("bccRecipients", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setBodyPreview(@Nullable String value) {
        this.backingStore.set("bodyPreview", (Object)value);
    }

    public void setCcRecipients(@Nullable List<Recipient> value) {
        this.backingStore.set("ccRecipients", value);
    }

    public void setConversationId(@Nullable String value) {
        this.backingStore.set("conversationId", (Object)value);
    }

    public void setConversationIndex(@Nullable byte[] value) {
        this.backingStore.set("conversationIndex", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setFlag(@Nullable FollowupFlag value) {
        this.backingStore.set("flag", (Object)value);
    }

    public void setFrom(@Nullable Recipient value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setImportance(@Nullable Importance value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setInferenceClassification(@Nullable InferenceClassificationType value) {
        this.backingStore.set("inferenceClassification", (Object)value);
    }

    public void setInternetMessageHeaders(@Nullable List<InternetMessageHeader> value) {
        this.backingStore.set("internetMessageHeaders", value);
    }

    public void setInternetMessageId(@Nullable String value) {
        this.backingStore.set("internetMessageId", (Object)value);
    }

    public void setIsDeliveryReceiptRequested(@Nullable Boolean value) {
        this.backingStore.set("isDeliveryReceiptRequested", (Object)value);
    }

    public void setIsDraft(@Nullable Boolean value) {
        this.backingStore.set("isDraft", (Object)value);
    }

    public void setIsRead(@Nullable Boolean value) {
        this.backingStore.set("isRead", (Object)value);
    }

    public void setIsReadReceiptRequested(@Nullable Boolean value) {
        this.backingStore.set("isReadReceiptRequested", (Object)value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setParentFolderId(@Nullable String value) {
        this.backingStore.set("parentFolderId", (Object)value);
    }

    public void setReceivedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("receivedDateTime", (Object)value);
    }

    public void setReplyTo(@Nullable List<Recipient> value) {
        this.backingStore.set("replyTo", value);
    }

    public void setSender(@Nullable Recipient value) {
        this.backingStore.set("sender", (Object)value);
    }

    public void setSentDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("sentDateTime", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setToRecipients(@Nullable List<Recipient> value) {
        this.backingStore.set("toRecipients", value);
    }

    public void setUniqueBody(@Nullable ItemBody value) {
        this.backingStore.set("uniqueBody", (Object)value);
    }

    public void setWebLink(@Nullable String value) {
        this.backingStore.set("webLink", (Object)value);
    }
}

