/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ScheduleChangeRequest;
import com.microsoft.graph.models.SwapShiftsChangeRequest;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OfferShiftRequest
extends ScheduleChangeRequest
implements Parsable {
    public OfferShiftRequest() {
        this.setOdataType("#microsoft.graph.offerShiftRequest");
    }

    @Nonnull
    public static OfferShiftRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.swapShiftsChangeRequest": {
                    return new SwapShiftsChangeRequest();
                }
            }
        }
        return new OfferShiftRequest();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("recipientActionDateTime", n -> this.setRecipientActionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("recipientActionMessage", n -> this.setRecipientActionMessage(n.getStringValue()));
        deserializerMap.put("recipientUserId", n -> this.setRecipientUserId(n.getStringValue()));
        deserializerMap.put("senderShiftId", n -> this.setSenderShiftId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getRecipientActionDateTime() {
        return (OffsetDateTime)this.backingStore.get("recipientActionDateTime");
    }

    @Nullable
    public String getRecipientActionMessage() {
        return (String)this.backingStore.get("recipientActionMessage");
    }

    @Nullable
    public String getRecipientUserId() {
        return (String)this.backingStore.get("recipientUserId");
    }

    @Nullable
    public String getSenderShiftId() {
        return (String)this.backingStore.get("senderShiftId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("recipientActionMessage", this.getRecipientActionMessage());
        writer.writeStringValue("recipientUserId", this.getRecipientUserId());
        writer.writeStringValue("senderShiftId", this.getSenderShiftId());
    }

    public void setRecipientActionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("recipientActionDateTime", (Object)value);
    }

    public void setRecipientActionMessage(@Nullable String value) {
        this.backingStore.set("recipientActionMessage", (Object)value);
    }

    public void setRecipientUserId(@Nullable String value) {
        this.backingStore.set("recipientUserId", (Object)value);
    }

    public void setSenderShiftId(@Nullable String value) {
        this.backingStore.set("senderShiftId", (Object)value);
    }
}

