/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Phone;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnlineMeetingInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public OnlineMeetingInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static OnlineMeetingInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OnlineMeetingInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getConferenceId() {
        return (String)this.backingStore.get("conferenceId");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("conferenceId", n -> this.setConferenceId(n.getStringValue()));
        deserializerMap.put("joinUrl", n -> this.setJoinUrl(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("phones", n -> this.setPhones(n.getCollectionOfObjectValues(Phone::createFromDiscriminatorValue)));
        deserializerMap.put("quickDial", n -> this.setQuickDial(n.getStringValue()));
        deserializerMap.put("tollFreeNumbers", n -> this.setTollFreeNumbers(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("tollNumber", n -> this.setTollNumber(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getJoinUrl() {
        return (String)this.backingStore.get("joinUrl");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<Phone> getPhones() {
        return (List)this.backingStore.get("phones");
    }

    @Nullable
    public String getQuickDial() {
        return (String)this.backingStore.get("quickDial");
    }

    @Nullable
    public List<String> getTollFreeNumbers() {
        return (List)this.backingStore.get("tollFreeNumbers");
    }

    @Nullable
    public String getTollNumber() {
        return (String)this.backingStore.get("tollNumber");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("conferenceId", this.getConferenceId());
        writer.writeStringValue("joinUrl", this.getJoinUrl());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("phones", this.getPhones());
        writer.writeStringValue("quickDial", this.getQuickDial());
        writer.writeCollectionOfPrimitiveValues("tollFreeNumbers", this.getTollFreeNumbers());
        writer.writeStringValue("tollNumber", this.getTollNumber());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConferenceId(@Nullable String value) {
        this.backingStore.set("conferenceId", (Object)value);
    }

    public void setJoinUrl(@Nullable String value) {
        this.backingStore.set("joinUrl", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPhones(@Nullable List<Phone> value) {
        this.backingStore.set("phones", value);
    }

    public void setQuickDial(@Nullable String value) {
        this.backingStore.set("quickDial", (Object)value);
    }

    public void setTollFreeNumbers(@Nullable List<String> value) {
        this.backingStore.set("tollFreeNumbers", value);
    }

    public void setTollNumber(@Nullable String value) {
        this.backingStore.set("tollNumber", (Object)value);
    }
}

