/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintConnector;
import com.microsoft.graph.models.PrintOperation;
import com.microsoft.graph.models.PrintService;
import com.microsoft.graph.models.PrintSettings;
import com.microsoft.graph.models.PrintTaskDefinition;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Print
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Print() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Print createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Print();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<PrintConnector> getConnectors() {
        return (List)this.backingStore.get("connectors");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("connectors", n -> this.setConnectors(n.getCollectionOfObjectValues(PrintConnector::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(PrintOperation::createFromDiscriminatorValue)));
        deserializerMap.put("printers", n -> this.setPrinters(n.getCollectionOfObjectValues(Printer::createFromDiscriminatorValue)));
        deserializerMap.put("services", n -> this.setServices(n.getCollectionOfObjectValues(PrintService::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings((PrintSettings)n.getObjectValue(PrintSettings::createFromDiscriminatorValue)));
        deserializerMap.put("shares", n -> this.setShares(n.getCollectionOfObjectValues(PrinterShare::createFromDiscriminatorValue)));
        deserializerMap.put("taskDefinitions", n -> this.setTaskDefinitions(n.getCollectionOfObjectValues(PrintTaskDefinition::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<PrintOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public List<Printer> getPrinters() {
        return (List)this.backingStore.get("printers");
    }

    @Nullable
    public List<PrintService> getServices() {
        return (List)this.backingStore.get("services");
    }

    @Nullable
    public PrintSettings getSettings() {
        return (PrintSettings)this.backingStore.get("settings");
    }

    @Nullable
    public List<PrinterShare> getShares() {
        return (List)this.backingStore.get("shares");
    }

    @Nullable
    public List<PrintTaskDefinition> getTaskDefinitions() {
        return (List)this.backingStore.get("taskDefinitions");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("connectors", this.getConnectors());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeCollectionOfObjectValues("printers", this.getPrinters());
        writer.writeCollectionOfObjectValues("services", this.getServices());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("shares", this.getShares());
        writer.writeCollectionOfObjectValues("taskDefinitions", this.getTaskDefinitions());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConnectors(@Nullable List<PrintConnector> value) {
        this.backingStore.set("connectors", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperations(@Nullable List<PrintOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setPrinters(@Nullable List<Printer> value) {
        this.backingStore.set("printers", value);
    }

    public void setServices(@Nullable List<PrintService> value) {
        this.backingStore.set("services", value);
    }

    public void setSettings(@Nullable PrintSettings value) {
        this.backingStore.set("settings", (Object)value);
    }

    public void setShares(@Nullable List<PrinterShare> value) {
        this.backingStore.set("shares", value);
    }

    public void setTaskDefinitions(@Nullable List<PrintTaskDefinition> value) {
        this.backingStore.set("taskDefinitions", value);
    }
}

