/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.FreeBusyError;
import com.microsoft.graph.models.ScheduleItem;
import com.microsoft.graph.models.WorkingHours;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ScheduleInformation
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ScheduleInformation() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ScheduleInformation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ScheduleInformation();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAvailabilityView() {
        return (String)this.backingStore.get("availabilityView");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public FreeBusyError getError() {
        return (FreeBusyError)this.backingStore.get("error");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("availabilityView", n -> this.setAvailabilityView(n.getStringValue()));
        deserializerMap.put("error", n -> this.setError((FreeBusyError)n.getObjectValue(FreeBusyError::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("scheduleId", n -> this.setScheduleId(n.getStringValue()));
        deserializerMap.put("scheduleItems", n -> this.setScheduleItems(n.getCollectionOfObjectValues(ScheduleItem::createFromDiscriminatorValue)));
        deserializerMap.put("workingHours", n -> this.setWorkingHours((WorkingHours)n.getObjectValue(WorkingHours::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getScheduleId() {
        return (String)this.backingStore.get("scheduleId");
    }

    @Nullable
    public List<ScheduleItem> getScheduleItems() {
        return (List)this.backingStore.get("scheduleItems");
    }

    @Nullable
    public WorkingHours getWorkingHours() {
        return (WorkingHours)this.backingStore.get("workingHours");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("availabilityView", this.getAvailabilityView());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("scheduleId", this.getScheduleId());
        writer.writeCollectionOfObjectValues("scheduleItems", this.getScheduleItems());
        writer.writeObjectValue("workingHours", (Parsable)this.getWorkingHours(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAvailabilityView(@Nullable String value) {
        this.backingStore.set("availabilityView", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setError(@Nullable FreeBusyError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setScheduleId(@Nullable String value) {
        this.backingStore.set("scheduleId", (Object)value);
    }

    public void setScheduleItems(@Nullable List<ScheduleItem> value) {
        this.backingStore.set("scheduleItems", value);
    }

    public void setWorkingHours(@Nullable WorkingHours value) {
        this.backingStore.set("workingHours", (Object)value);
    }
}

