/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ServiceHealthIssue;
import com.microsoft.graph.models.ServiceHealthStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ServiceHealth
extends Entity
implements Parsable {
    @Nonnull
    public static ServiceHealth createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ServiceHealth();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("issues", n -> this.setIssues(n.getCollectionOfObjectValues(ServiceHealthIssue::createFromDiscriminatorValue)));
        deserializerMap.put("service", n -> this.setService(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((ServiceHealthStatus)n.getEnumValue(ServiceHealthStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<ServiceHealthIssue> getIssues() {
        return (List)this.backingStore.get("issues");
    }

    @Nullable
    public String getService() {
        return (String)this.backingStore.get("service");
    }

    @Nullable
    public ServiceHealthStatus getStatus() {
        return (ServiceHealthStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("issues", this.getIssues());
        writer.writeStringValue("service", this.getService());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setIssues(@Nullable List<ServiceHealthIssue> value) {
        this.backingStore.set("issues", value);
    }

    public void setService(@Nullable String value) {
        this.backingStore.set("service", (Object)value);
    }

    public void setStatus(@Nullable ServiceHealthStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

