/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ServiceAnnouncementBase;
import com.microsoft.graph.models.ServiceHealthClassificationType;
import com.microsoft.graph.models.ServiceHealthIssuePost;
import com.microsoft.graph.models.ServiceHealthOrigin;
import com.microsoft.graph.models.ServiceHealthStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ServiceHealthIssue
extends ServiceAnnouncementBase
implements Parsable {
    public ServiceHealthIssue() {
        this.setOdataType("#microsoft.graph.serviceHealthIssue");
    }

    @Nonnull
    public static ServiceHealthIssue createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ServiceHealthIssue();
    }

    @Nullable
    public ServiceHealthClassificationType getClassification() {
        return (ServiceHealthClassificationType)((Object)this.backingStore.get("classification"));
    }

    @Nullable
    public String getFeature() {
        return (String)this.backingStore.get("feature");
    }

    @Nullable
    public String getFeatureGroup() {
        return (String)this.backingStore.get("featureGroup");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("classification", n -> this.setClassification((ServiceHealthClassificationType)n.getEnumValue(ServiceHealthClassificationType::forValue)));
        deserializerMap.put("feature", n -> this.setFeature(n.getStringValue()));
        deserializerMap.put("featureGroup", n -> this.setFeatureGroup(n.getStringValue()));
        deserializerMap.put("impactDescription", n -> this.setImpactDescription(n.getStringValue()));
        deserializerMap.put("isResolved", n -> this.setIsResolved(n.getBooleanValue()));
        deserializerMap.put("origin", n -> this.setOrigin((ServiceHealthOrigin)n.getEnumValue(ServiceHealthOrigin::forValue)));
        deserializerMap.put("posts", n -> this.setPosts(n.getCollectionOfObjectValues(ServiceHealthIssuePost::createFromDiscriminatorValue)));
        deserializerMap.put("service", n -> this.setService(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((ServiceHealthStatus)n.getEnumValue(ServiceHealthStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getImpactDescription() {
        return (String)this.backingStore.get("impactDescription");
    }

    @Nullable
    public Boolean getIsResolved() {
        return (Boolean)this.backingStore.get("isResolved");
    }

    @Nullable
    public ServiceHealthOrigin getOrigin() {
        return (ServiceHealthOrigin)((Object)this.backingStore.get("origin"));
    }

    @Nullable
    public List<ServiceHealthIssuePost> getPosts() {
        return (List)this.backingStore.get("posts");
    }

    @Nullable
    public String getService() {
        return (String)this.backingStore.get("service");
    }

    @Nullable
    public ServiceHealthStatus getStatus() {
        return (ServiceHealthStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("classification", (Enum)this.getClassification());
        writer.writeStringValue("feature", this.getFeature());
        writer.writeStringValue("featureGroup", this.getFeatureGroup());
        writer.writeStringValue("impactDescription", this.getImpactDescription());
        writer.writeBooleanValue("isResolved", this.getIsResolved());
        writer.writeEnumValue("origin", (Enum)this.getOrigin());
        writer.writeCollectionOfObjectValues("posts", this.getPosts());
        writer.writeStringValue("service", this.getService());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setClassification(@Nullable ServiceHealthClassificationType value) {
        this.backingStore.set("classification", (Object)value);
    }

    public void setFeature(@Nullable String value) {
        this.backingStore.set("feature", (Object)value);
    }

    public void setFeatureGroup(@Nullable String value) {
        this.backingStore.set("featureGroup", (Object)value);
    }

    public void setImpactDescription(@Nullable String value) {
        this.backingStore.set("impactDescription", (Object)value);
    }

    public void setIsResolved(@Nullable Boolean value) {
        this.backingStore.set("isResolved", (Object)value);
    }

    public void setOrigin(@Nullable ServiceHealthOrigin value) {
        this.backingStore.set("origin", (Object)value);
    }

    public void setPosts(@Nullable List<ServiceHealthIssuePost> value) {
        this.backingStore.set("posts", value);
    }

    public void setService(@Nullable String value) {
        this.backingStore.set("service", (Object)value);
    }

    public void setStatus(@Nullable ServiceHealthStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

