/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.identitygovernance.LifecycleWorkflowProcessingStatus;
import com.microsoft.graph.models.identitygovernance.Task;
import com.microsoft.graph.models.identitygovernance.TaskDefinition;
import com.microsoft.graph.models.identitygovernance.TaskProcessingResult;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TaskReport
extends Entity
implements Parsable {
    @Nonnull
    public static TaskReport createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TaskReport();
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public Integer getFailedUsersCount() {
        return (Integer)this.backingStore.get("failedUsersCount");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("failedUsersCount", n -> this.setFailedUsersCount(n.getIntegerValue()));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("processingStatus", n -> this.setProcessingStatus((LifecycleWorkflowProcessingStatus)n.getEnumValue(LifecycleWorkflowProcessingStatus::forValue)));
        deserializerMap.put("runId", n -> this.setRunId(n.getStringValue()));
        deserializerMap.put("startedDateTime", n -> this.setStartedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("successfulUsersCount", n -> this.setSuccessfulUsersCount(n.getIntegerValue()));
        deserializerMap.put("task", n -> this.setTask((Task)n.getObjectValue(Task::createFromDiscriminatorValue)));
        deserializerMap.put("taskDefinition", n -> this.setTaskDefinition((TaskDefinition)n.getObjectValue(TaskDefinition::createFromDiscriminatorValue)));
        deserializerMap.put("taskProcessingResults", n -> this.setTaskProcessingResults(n.getCollectionOfObjectValues(TaskProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("totalUsersCount", n -> this.setTotalUsersCount(n.getIntegerValue()));
        deserializerMap.put("unprocessedUsersCount", n -> this.setUnprocessedUsersCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public LifecycleWorkflowProcessingStatus getProcessingStatus() {
        return (LifecycleWorkflowProcessingStatus)((Object)this.backingStore.get("processingStatus"));
    }

    @Nullable
    public String getRunId() {
        return (String)this.backingStore.get("runId");
    }

    @Nullable
    public OffsetDateTime getStartedDateTime() {
        return (OffsetDateTime)this.backingStore.get("startedDateTime");
    }

    @Nullable
    public Integer getSuccessfulUsersCount() {
        return (Integer)this.backingStore.get("successfulUsersCount");
    }

    @Nullable
    public Task getTask() {
        return (Task)this.backingStore.get("task");
    }

    @Nullable
    public TaskDefinition getTaskDefinition() {
        return (TaskDefinition)this.backingStore.get("taskDefinition");
    }

    @Nullable
    public List<TaskProcessingResult> getTaskProcessingResults() {
        return (List)this.backingStore.get("taskProcessingResults");
    }

    @Nullable
    public Integer getTotalUsersCount() {
        return (Integer)this.backingStore.get("totalUsersCount");
    }

    @Nullable
    public Integer getUnprocessedUsersCount() {
        return (Integer)this.backingStore.get("unprocessedUsersCount");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeIntegerValue("failedUsersCount", this.getFailedUsersCount());
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeEnumValue("processingStatus", (Enum)this.getProcessingStatus());
        writer.writeStringValue("runId", this.getRunId());
        writer.writeOffsetDateTimeValue("startedDateTime", this.getStartedDateTime());
        writer.writeIntegerValue("successfulUsersCount", this.getSuccessfulUsersCount());
        writer.writeObjectValue("task", (Parsable)this.getTask(), new Parsable[0]);
        writer.writeObjectValue("taskDefinition", (Parsable)this.getTaskDefinition(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("taskProcessingResults", this.getTaskProcessingResults());
        writer.writeIntegerValue("totalUsersCount", this.getTotalUsersCount());
        writer.writeIntegerValue("unprocessedUsersCount", this.getUnprocessedUsersCount());
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setFailedUsersCount(@Nullable Integer value) {
        this.backingStore.set("failedUsersCount", (Object)value);
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setProcessingStatus(@Nullable LifecycleWorkflowProcessingStatus value) {
        this.backingStore.set("processingStatus", (Object)value);
    }

    public void setRunId(@Nullable String value) {
        this.backingStore.set("runId", (Object)value);
    }

    public void setStartedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startedDateTime", (Object)value);
    }

    public void setSuccessfulUsersCount(@Nullable Integer value) {
        this.backingStore.set("successfulUsersCount", (Object)value);
    }

    public void setTask(@Nullable Task value) {
        this.backingStore.set("task", (Object)value);
    }

    public void setTaskDefinition(@Nullable TaskDefinition value) {
        this.backingStore.set("taskDefinition", (Object)value);
    }

    public void setTaskProcessingResults(@Nullable List<TaskProcessingResult> value) {
        this.backingStore.set("taskProcessingResults", value);
    }

    public void setTotalUsersCount(@Nullable Integer value) {
        this.backingStore.set("totalUsersCount", (Object)value);
    }

    public void setUnprocessedUsersCount(@Nullable Integer value) {
        this.backingStore.set("unprocessedUsersCount", (Object)value);
    }
}

