/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.partners.billing;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.LongRunningOperationStatus;
import com.microsoft.graph.models.partners.billing.ExportSuccessOperation;
import com.microsoft.graph.models.partners.billing.FailedOperation;
import com.microsoft.graph.models.partners.billing.RunningOperation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Operation
extends Entity
implements Parsable {
    @Nonnull
    public static Operation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.partners.billing.exportSuccessOperation": {
                    return new ExportSuccessOperation();
                }
                case "#microsoft.graph.partners.billing.failedOperation": {
                    return new FailedOperation();
                }
                case "#microsoft.graph.partners.billing.runningOperation": {
                    return new RunningOperation();
                }
            }
        }
        return new Operation();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastActionDateTime", n -> this.setLastActionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((LongRunningOperationStatus)n.getEnumValue(LongRunningOperationStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastActionDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastActionDateTime");
    }

    @Nullable
    public LongRunningOperationStatus getStatus() {
        return (LongRunningOperationStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("lastActionDateTime", this.getLastActionDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setLastActionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastActionDateTime", (Object)value);
    }

    public void setStatus(@Nullable LongRunningOperationStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

