/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.Artifact;
import com.microsoft.graph.models.security.HostComponent;
import com.microsoft.graph.models.security.HostCookie;
import com.microsoft.graph.models.security.HostPair;
import com.microsoft.graph.models.security.HostPort;
import com.microsoft.graph.models.security.HostReputation;
import com.microsoft.graph.models.security.HostSslCertificate;
import com.microsoft.graph.models.security.HostTracker;
import com.microsoft.graph.models.security.Hostname;
import com.microsoft.graph.models.security.IpAddress;
import com.microsoft.graph.models.security.PassiveDnsRecord;
import com.microsoft.graph.models.security.Subdomain;
import com.microsoft.graph.models.security.WhoisRecord;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Host
extends Artifact
implements Parsable {
    public Host() {
        this.setOdataType("#microsoft.graph.security.host");
    }

    @Nonnull
    public static Host createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.hostname": {
                    return new Hostname();
                }
                case "#microsoft.graph.security.ipAddress": {
                    return new IpAddress();
                }
            }
        }
        return new Host();
    }

    @Nullable
    public List<HostPair> getChildHostPairs() {
        return (List)this.backingStore.get("childHostPairs");
    }

    @Nullable
    public List<HostComponent> getComponents() {
        return (List)this.backingStore.get("components");
    }

    @Nullable
    public List<HostCookie> getCookies() {
        return (List)this.backingStore.get("cookies");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("childHostPairs", n -> this.setChildHostPairs(n.getCollectionOfObjectValues(HostPair::createFromDiscriminatorValue)));
        deserializerMap.put("components", n -> this.setComponents(n.getCollectionOfObjectValues(HostComponent::createFromDiscriminatorValue)));
        deserializerMap.put("cookies", n -> this.setCookies(n.getCollectionOfObjectValues(HostCookie::createFromDiscriminatorValue)));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("hostPairs", n -> this.setHostPairs(n.getCollectionOfObjectValues(HostPair::createFromDiscriminatorValue)));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("parentHostPairs", n -> this.setParentHostPairs(n.getCollectionOfObjectValues(HostPair::createFromDiscriminatorValue)));
        deserializerMap.put("passiveDns", n -> this.setPassiveDns(n.getCollectionOfObjectValues(PassiveDnsRecord::createFromDiscriminatorValue)));
        deserializerMap.put("passiveDnsReverse", n -> this.setPassiveDnsReverse(n.getCollectionOfObjectValues(PassiveDnsRecord::createFromDiscriminatorValue)));
        deserializerMap.put("ports", n -> this.setPorts(n.getCollectionOfObjectValues(HostPort::createFromDiscriminatorValue)));
        deserializerMap.put("reputation", n -> this.setReputation((HostReputation)n.getObjectValue(HostReputation::createFromDiscriminatorValue)));
        deserializerMap.put("sslCertificates", n -> this.setSslCertificates(n.getCollectionOfObjectValues(HostSslCertificate::createFromDiscriminatorValue)));
        deserializerMap.put("subdomains", n -> this.setSubdomains(n.getCollectionOfObjectValues(Subdomain::createFromDiscriminatorValue)));
        deserializerMap.put("trackers", n -> this.setTrackers(n.getCollectionOfObjectValues(HostTracker::createFromDiscriminatorValue)));
        deserializerMap.put("whois", n -> this.setWhois((WhoisRecord)n.getObjectValue(WhoisRecord::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public List<HostPair> getHostPairs() {
        return (List)this.backingStore.get("hostPairs");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public List<HostPair> getParentHostPairs() {
        return (List)this.backingStore.get("parentHostPairs");
    }

    @Nullable
    public List<PassiveDnsRecord> getPassiveDns() {
        return (List)this.backingStore.get("passiveDns");
    }

    @Nullable
    public List<PassiveDnsRecord> getPassiveDnsReverse() {
        return (List)this.backingStore.get("passiveDnsReverse");
    }

    @Nullable
    public List<HostPort> getPorts() {
        return (List)this.backingStore.get("ports");
    }

    @Nullable
    public HostReputation getReputation() {
        return (HostReputation)this.backingStore.get("reputation");
    }

    @Nullable
    public List<HostSslCertificate> getSslCertificates() {
        return (List)this.backingStore.get("sslCertificates");
    }

    @Nullable
    public List<Subdomain> getSubdomains() {
        return (List)this.backingStore.get("subdomains");
    }

    @Nullable
    public List<HostTracker> getTrackers() {
        return (List)this.backingStore.get("trackers");
    }

    @Nullable
    public WhoisRecord getWhois() {
        return (WhoisRecord)this.backingStore.get("whois");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("childHostPairs", this.getChildHostPairs());
        writer.writeCollectionOfObjectValues("components", this.getComponents());
        writer.writeCollectionOfObjectValues("cookies", this.getCookies());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeCollectionOfObjectValues("hostPairs", this.getHostPairs());
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeCollectionOfObjectValues("parentHostPairs", this.getParentHostPairs());
        writer.writeCollectionOfObjectValues("passiveDns", this.getPassiveDns());
        writer.writeCollectionOfObjectValues("passiveDnsReverse", this.getPassiveDnsReverse());
        writer.writeCollectionOfObjectValues("ports", this.getPorts());
        writer.writeObjectValue("reputation", (Parsable)this.getReputation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("sslCertificates", this.getSslCertificates());
        writer.writeCollectionOfObjectValues("subdomains", this.getSubdomains());
        writer.writeCollectionOfObjectValues("trackers", this.getTrackers());
        writer.writeObjectValue("whois", (Parsable)this.getWhois(), new Parsable[0]);
    }

    public void setChildHostPairs(@Nullable List<HostPair> value) {
        this.backingStore.set("childHostPairs", value);
    }

    public void setComponents(@Nullable List<HostComponent> value) {
        this.backingStore.set("components", value);
    }

    public void setCookies(@Nullable List<HostCookie> value) {
        this.backingStore.set("cookies", value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setHostPairs(@Nullable List<HostPair> value) {
        this.backingStore.set("hostPairs", value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setParentHostPairs(@Nullable List<HostPair> value) {
        this.backingStore.set("parentHostPairs", value);
    }

    public void setPassiveDns(@Nullable List<PassiveDnsRecord> value) {
        this.backingStore.set("passiveDns", value);
    }

    public void setPassiveDnsReverse(@Nullable List<PassiveDnsRecord> value) {
        this.backingStore.set("passiveDnsReverse", value);
    }

    public void setPorts(@Nullable List<HostPort> value) {
        this.backingStore.set("ports", value);
    }

    public void setReputation(@Nullable HostReputation value) {
        this.backingStore.set("reputation", (Object)value);
    }

    public void setSslCertificates(@Nullable List<HostSslCertificate> value) {
        this.backingStore.set("sslCertificates", value);
    }

    public void setSubdomains(@Nullable List<Subdomain> value) {
        this.backingStore.set("subdomains", value);
    }

    public void setTrackers(@Nullable List<HostTracker> value) {
        this.backingStore.set("trackers", value);
    }

    public void setWhois(@Nullable WhoisRecord value) {
        this.backingStore.set("whois", (Object)value);
    }
}

