/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.Host;
import com.microsoft.graph.models.security.HostPortBanner;
import com.microsoft.graph.models.security.HostPortComponent;
import com.microsoft.graph.models.security.HostPortProtocol;
import com.microsoft.graph.models.security.HostPortStatus;
import com.microsoft.graph.models.security.SslCertificate;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class HostPort
extends Entity
implements Parsable {
    @Nonnull
    public static HostPort createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new HostPort();
    }

    @Nullable
    public List<HostPortBanner> getBanners() {
        return (List)this.backingStore.get("banners");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("banners", n -> this.setBanners(n.getCollectionOfObjectValues(HostPortBanner::createFromDiscriminatorValue)));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("host", n -> this.setHost((Host)n.getObjectValue(Host::createFromDiscriminatorValue)));
        deserializerMap.put("lastScanDateTime", n -> this.setLastScanDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("mostRecentSslCertificate", n -> this.setMostRecentSslCertificate((SslCertificate)n.getObjectValue(SslCertificate::createFromDiscriminatorValue)));
        deserializerMap.put("port", n -> this.setPort(n.getIntegerValue()));
        deserializerMap.put("protocol", n -> this.setProtocol((HostPortProtocol)n.getEnumValue(HostPortProtocol::forValue)));
        deserializerMap.put("services", n -> this.setServices(n.getCollectionOfObjectValues(HostPortComponent::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((HostPortStatus)n.getEnumValue(HostPortStatus::forValue)));
        deserializerMap.put("timesObserved", n -> this.setTimesObserved(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public Host getHost() {
        return (Host)this.backingStore.get("host");
    }

    @Nullable
    public OffsetDateTime getLastScanDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastScanDateTime");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public SslCertificate getMostRecentSslCertificate() {
        return (SslCertificate)this.backingStore.get("mostRecentSslCertificate");
    }

    @Nullable
    public Integer getPort() {
        return (Integer)this.backingStore.get("port");
    }

    @Nullable
    public HostPortProtocol getProtocol() {
        return (HostPortProtocol)((Object)this.backingStore.get("protocol"));
    }

    @Nullable
    public List<HostPortComponent> getServices() {
        return (List)this.backingStore.get("services");
    }

    @Nullable
    public HostPortStatus getStatus() {
        return (HostPortStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public Integer getTimesObserved() {
        return (Integer)this.backingStore.get("timesObserved");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("banners", this.getBanners());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeObjectValue("host", (Parsable)this.getHost(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastScanDateTime", this.getLastScanDateTime());
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeObjectValue("mostRecentSslCertificate", (Parsable)this.getMostRecentSslCertificate(), new Parsable[0]);
        writer.writeIntegerValue("port", this.getPort());
        writer.writeEnumValue("protocol", (Enum)this.getProtocol());
        writer.writeCollectionOfObjectValues("services", this.getServices());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeIntegerValue("timesObserved", this.getTimesObserved());
    }

    public void setBanners(@Nullable List<HostPortBanner> value) {
        this.backingStore.set("banners", value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setHost(@Nullable Host value) {
        this.backingStore.set("host", (Object)value);
    }

    public void setLastScanDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastScanDateTime", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setMostRecentSslCertificate(@Nullable SslCertificate value) {
        this.backingStore.set("mostRecentSslCertificate", (Object)value);
    }

    public void setPort(@Nullable Integer value) {
        this.backingStore.set("port", (Object)value);
    }

    public void setProtocol(@Nullable HostPortProtocol value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setServices(@Nullable List<HostPortComponent> value) {
        this.backingStore.set("services", value);
    }

    public void setStatus(@Nullable HostPortStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setTimesObserved(@Nullable Integer value) {
        this.backingStore.set("timesObserved", (Object)value);
    }
}

