/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.users.item.calendars.item.calendarview.item;

import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.accept.AcceptRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.attachments.AttachmentsRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.calendar.CalendarRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.cancel.CancelRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.decline.DeclineRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.dismissreminder.DismissReminderRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.extensions.ExtensionsRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.forward.ForwardRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.instances.InstancesRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.snoozereminder.SnoozeReminderRequestBuilder;
import com.microsoft.graph.users.item.calendars.item.calendarview.item.tentativelyaccept.TentativelyAcceptRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EventItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AcceptRequestBuilder accept() {
        return new AcceptRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AttachmentsRequestBuilder attachments() {
        return new AttachmentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CalendarRequestBuilder calendar() {
        return new CalendarRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CancelRequestBuilder cancel() {
        return new CancelRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DeclineRequestBuilder decline() {
        return new DeclineRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DismissReminderRequestBuilder dismissReminder() {
        return new DismissReminderRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExtensionsRequestBuilder extensions() {
        return new ExtensionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ForwardRequestBuilder forward() {
        return new ForwardRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public InstancesRequestBuilder instances() {
        return new InstancesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SnoozeReminderRequestBuilder snoozeReminder() {
        return new SnoozeReminderRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TentativelyAcceptRequestBuilder tentativelyAccept() {
        return new TentativelyAcceptRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public EventItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/calendars/{calendar%2Did}/calendarView/{event%2Did}?endDateTime={endDateTime}&startDateTime={startDateTime}{&%24select}", pathParameters);
    }

    public EventItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/calendars/{calendar%2Did}/calendarView/{event%2Did}?endDateTime={endDateTime}&startDateTime={startDateTime}{&%24select}", rawUrl);
    }

    @Nullable
    public Event get() {
        return this.get(null);
    }

    @Nullable
    public Event get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Event)this.requestAdapter.send(requestInfo, errorMapping, Event::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public EventItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new EventItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String endDateTime;
        @Nullable
        public String[] select;
        @Nullable
        public String startDateTime;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("endDateTime", this.endDateTime);
            allQueryParams.put("startDateTime", this.startDateTime);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

