/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.applications.item;

import com.microsoft.graph.applications.item.addkey.AddKeyRequestBuilder;
import com.microsoft.graph.applications.item.addpassword.AddPasswordRequestBuilder;
import com.microsoft.graph.applications.item.appmanagementpolicies.AppManagementPoliciesRequestBuilder;
import com.microsoft.graph.applications.item.checkmembergroups.CheckMemberGroupsRequestBuilder;
import com.microsoft.graph.applications.item.checkmemberobjects.CheckMemberObjectsRequestBuilder;
import com.microsoft.graph.applications.item.createdonbehalfof.CreatedOnBehalfOfRequestBuilder;
import com.microsoft.graph.applications.item.extensionproperties.ExtensionPropertiesRequestBuilder;
import com.microsoft.graph.applications.item.federatedidentitycredentials.FederatedIdentityCredentialsRequestBuilder;
import com.microsoft.graph.applications.item.federatedidentitycredentialswithname.FederatedIdentityCredentialsWithNameRequestBuilder;
import com.microsoft.graph.applications.item.getmembergroups.GetMemberGroupsRequestBuilder;
import com.microsoft.graph.applications.item.getmemberobjects.GetMemberObjectsRequestBuilder;
import com.microsoft.graph.applications.item.homerealmdiscoverypolicies.HomeRealmDiscoveryPoliciesRequestBuilder;
import com.microsoft.graph.applications.item.logo.LogoRequestBuilder;
import com.microsoft.graph.applications.item.owners.OwnersRequestBuilder;
import com.microsoft.graph.applications.item.removekey.RemoveKeyRequestBuilder;
import com.microsoft.graph.applications.item.removepassword.RemovePasswordRequestBuilder;
import com.microsoft.graph.applications.item.restore.RestoreRequestBuilder;
import com.microsoft.graph.applications.item.setverifiedpublisher.SetVerifiedPublisherRequestBuilder;
import com.microsoft.graph.applications.item.synchronization.SynchronizationRequestBuilder;
import com.microsoft.graph.applications.item.tokenissuancepolicies.TokenIssuancePoliciesRequestBuilder;
import com.microsoft.graph.applications.item.tokenlifetimepolicies.TokenLifetimePoliciesRequestBuilder;
import com.microsoft.graph.applications.item.unsetverifiedpublisher.UnsetVerifiedPublisherRequestBuilder;
import com.microsoft.graph.models.Application;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ApplicationItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AddKeyRequestBuilder addKey() {
        return new AddKeyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AddPasswordRequestBuilder addPassword() {
        return new AddPasswordRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AppManagementPoliciesRequestBuilder appManagementPolicies() {
        return new AppManagementPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CheckMemberGroupsRequestBuilder checkMemberGroups() {
        return new CheckMemberGroupsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CheckMemberObjectsRequestBuilder checkMemberObjects() {
        return new CheckMemberObjectsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreatedOnBehalfOfRequestBuilder createdOnBehalfOf() {
        return new CreatedOnBehalfOfRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExtensionPropertiesRequestBuilder extensionProperties() {
        return new ExtensionPropertiesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public FederatedIdentityCredentialsRequestBuilder federatedIdentityCredentials() {
        return new FederatedIdentityCredentialsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GetMemberGroupsRequestBuilder getMemberGroups() {
        return new GetMemberGroupsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GetMemberObjectsRequestBuilder getMemberObjects() {
        return new GetMemberObjectsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HomeRealmDiscoveryPoliciesRequestBuilder homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LogoRequestBuilder logo() {
        return new LogoRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OwnersRequestBuilder owners() {
        return new OwnersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RemoveKeyRequestBuilder removeKey() {
        return new RemoveKeyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RemovePasswordRequestBuilder removePassword() {
        return new RemovePasswordRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RestoreRequestBuilder restore() {
        return new RestoreRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SetVerifiedPublisherRequestBuilder setVerifiedPublisher() {
        return new SetVerifiedPublisherRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SynchronizationRequestBuilder synchronization() {
        return new SynchronizationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TokenIssuancePoliciesRequestBuilder tokenIssuancePolicies() {
        return new TokenIssuancePoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TokenLifetimePoliciesRequestBuilder tokenLifetimePolicies() {
        return new TokenLifetimePoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UnsetVerifiedPublisherRequestBuilder unsetVerifiedPublisher() {
        return new UnsetVerifiedPublisherRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public ApplicationItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/applications/{application%2Did}{?%24expand,%24select}", pathParameters);
    }

    public ApplicationItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/applications/{application%2Did}{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nonnull
    public FederatedIdentityCredentialsWithNameRequestBuilder federatedIdentityCredentialsWithName(@Nonnull String name) {
        Objects.requireNonNull(name);
        return new FederatedIdentityCredentialsWithNameRequestBuilder(this.pathParameters, this.requestAdapter, name);
    }

    @Nullable
    public Application get() {
        return this.get(null);
    }

    @Nullable
    public Application get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Application)this.requestAdapter.send(requestInfo, errorMapping, Application::createFromDiscriminatorValue);
    }

    @Nullable
    public Application patch(@Nonnull Application body) {
        return this.patch(body, null);
    }

    @Nullable
    public Application patch(@Nonnull Application body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Application)this.requestAdapter.send(requestInfo, errorMapping, Application::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Application body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Application body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ApplicationItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ApplicationItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

