/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MimeContent;
import com.microsoft.graph.models.RgbColor;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IntuneBrand
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public IntuneBrand() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static IntuneBrand createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IntuneBrand();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getContactITEmailAddress() {
        return (String)this.backingStore.get("contactITEmailAddress");
    }

    @Nullable
    public String getContactITName() {
        return (String)this.backingStore.get("contactITName");
    }

    @Nullable
    public String getContactITNotes() {
        return (String)this.backingStore.get("contactITNotes");
    }

    @Nullable
    public String getContactITPhoneNumber() {
        return (String)this.backingStore.get("contactITPhoneNumber");
    }

    @Nullable
    public MimeContent getDarkBackgroundLogo() {
        return (MimeContent)this.backingStore.get("darkBackgroundLogo");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(15);
        deserializerMap.put("contactITEmailAddress", n -> this.setContactITEmailAddress(n.getStringValue()));
        deserializerMap.put("contactITName", n -> this.setContactITName(n.getStringValue()));
        deserializerMap.put("contactITNotes", n -> this.setContactITNotes(n.getStringValue()));
        deserializerMap.put("contactITPhoneNumber", n -> this.setContactITPhoneNumber(n.getStringValue()));
        deserializerMap.put("darkBackgroundLogo", n -> this.setDarkBackgroundLogo((MimeContent)n.getObjectValue(MimeContent::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lightBackgroundLogo", n -> this.setLightBackgroundLogo((MimeContent)n.getObjectValue(MimeContent::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("onlineSupportSiteName", n -> this.setOnlineSupportSiteName(n.getStringValue()));
        deserializerMap.put("onlineSupportSiteUrl", n -> this.setOnlineSupportSiteUrl(n.getStringValue()));
        deserializerMap.put("privacyUrl", n -> this.setPrivacyUrl(n.getStringValue()));
        deserializerMap.put("showDisplayNameNextToLogo", n -> this.setShowDisplayNameNextToLogo(n.getBooleanValue()));
        deserializerMap.put("showLogo", n -> this.setShowLogo(n.getBooleanValue()));
        deserializerMap.put("showNameNextToLogo", n -> this.setShowNameNextToLogo(n.getBooleanValue()));
        deserializerMap.put("themeColor", n -> this.setThemeColor((RgbColor)n.getObjectValue(RgbColor::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public MimeContent getLightBackgroundLogo() {
        return (MimeContent)this.backingStore.get("lightBackgroundLogo");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOnlineSupportSiteName() {
        return (String)this.backingStore.get("onlineSupportSiteName");
    }

    @Nullable
    public String getOnlineSupportSiteUrl() {
        return (String)this.backingStore.get("onlineSupportSiteUrl");
    }

    @Nullable
    public String getPrivacyUrl() {
        return (String)this.backingStore.get("privacyUrl");
    }

    @Nullable
    public Boolean getShowDisplayNameNextToLogo() {
        return (Boolean)this.backingStore.get("showDisplayNameNextToLogo");
    }

    @Nullable
    public Boolean getShowLogo() {
        return (Boolean)this.backingStore.get("showLogo");
    }

    @Nullable
    public Boolean getShowNameNextToLogo() {
        return (Boolean)this.backingStore.get("showNameNextToLogo");
    }

    @Nullable
    public RgbColor getThemeColor() {
        return (RgbColor)this.backingStore.get("themeColor");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("contactITEmailAddress", this.getContactITEmailAddress());
        writer.writeStringValue("contactITName", this.getContactITName());
        writer.writeStringValue("contactITNotes", this.getContactITNotes());
        writer.writeStringValue("contactITPhoneNumber", this.getContactITPhoneNumber());
        writer.writeObjectValue("darkBackgroundLogo", (Parsable)this.getDarkBackgroundLogo(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("lightBackgroundLogo", (Parsable)this.getLightBackgroundLogo(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("onlineSupportSiteName", this.getOnlineSupportSiteName());
        writer.writeStringValue("onlineSupportSiteUrl", this.getOnlineSupportSiteUrl());
        writer.writeStringValue("privacyUrl", this.getPrivacyUrl());
        writer.writeBooleanValue("showDisplayNameNextToLogo", this.getShowDisplayNameNextToLogo());
        writer.writeBooleanValue("showLogo", this.getShowLogo());
        writer.writeBooleanValue("showNameNextToLogo", this.getShowNameNextToLogo());
        writer.writeObjectValue("themeColor", (Parsable)this.getThemeColor(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setContactITEmailAddress(@Nullable String value) {
        this.backingStore.set("contactITEmailAddress", (Object)value);
    }

    public void setContactITName(@Nullable String value) {
        this.backingStore.set("contactITName", (Object)value);
    }

    public void setContactITNotes(@Nullable String value) {
        this.backingStore.set("contactITNotes", (Object)value);
    }

    public void setContactITPhoneNumber(@Nullable String value) {
        this.backingStore.set("contactITPhoneNumber", (Object)value);
    }

    public void setDarkBackgroundLogo(@Nullable MimeContent value) {
        this.backingStore.set("darkBackgroundLogo", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLightBackgroundLogo(@Nullable MimeContent value) {
        this.backingStore.set("lightBackgroundLogo", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOnlineSupportSiteName(@Nullable String value) {
        this.backingStore.set("onlineSupportSiteName", (Object)value);
    }

    public void setOnlineSupportSiteUrl(@Nullable String value) {
        this.backingStore.set("onlineSupportSiteUrl", (Object)value);
    }

    public void setPrivacyUrl(@Nullable String value) {
        this.backingStore.set("privacyUrl", (Object)value);
    }

    public void setShowDisplayNameNextToLogo(@Nullable Boolean value) {
        this.backingStore.set("showDisplayNameNextToLogo", (Object)value);
    }

    public void setShowLogo(@Nullable Boolean value) {
        this.backingStore.set("showLogo", (Object)value);
    }

    public void setShowNameNextToLogo(@Nullable Boolean value) {
        this.backingStore.set("showNameNextToLogo", (Object)value);
    }

    public void setThemeColor(@Nullable RgbColor value) {
        this.backingStore.set("themeColor", (Object)value);
    }
}

