/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.NotebookLinks;
import com.microsoft.graph.models.OnenoteEntityHierarchyModel;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.graph.models.OnenoteUserRole;
import com.microsoft.graph.models.SectionGroup;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Notebook
extends OnenoteEntityHierarchyModel
implements Parsable {
    public Notebook() {
        this.setOdataType("#microsoft.graph.notebook");
    }

    @Nonnull
    public static Notebook createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Notebook();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("isDefault", n -> this.setIsDefault(n.getBooleanValue()));
        deserializerMap.put("isShared", n -> this.setIsShared(n.getBooleanValue()));
        deserializerMap.put("links", n -> this.setLinks((NotebookLinks)n.getObjectValue(NotebookLinks::createFromDiscriminatorValue)));
        deserializerMap.put("sectionGroups", n -> this.setSectionGroups(n.getCollectionOfObjectValues(SectionGroup::createFromDiscriminatorValue)));
        deserializerMap.put("sectionGroupsUrl", n -> this.setSectionGroupsUrl(n.getStringValue()));
        deserializerMap.put("sections", n -> this.setSections(n.getCollectionOfObjectValues(OnenoteSection::createFromDiscriminatorValue)));
        deserializerMap.put("sectionsUrl", n -> this.setSectionsUrl(n.getStringValue()));
        deserializerMap.put("userRole", n -> this.setUserRole((OnenoteUserRole)n.getEnumValue(OnenoteUserRole::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsDefault() {
        return (Boolean)this.backingStore.get("isDefault");
    }

    @Nullable
    public Boolean getIsShared() {
        return (Boolean)this.backingStore.get("isShared");
    }

    @Nullable
    public NotebookLinks getLinks() {
        return (NotebookLinks)this.backingStore.get("links");
    }

    @Nullable
    public List<SectionGroup> getSectionGroups() {
        return (List)this.backingStore.get("sectionGroups");
    }

    @Nullable
    public String getSectionGroupsUrl() {
        return (String)this.backingStore.get("sectionGroupsUrl");
    }

    @Nullable
    public List<OnenoteSection> getSections() {
        return (List)this.backingStore.get("sections");
    }

    @Nullable
    public String getSectionsUrl() {
        return (String)this.backingStore.get("sectionsUrl");
    }

    @Nullable
    public OnenoteUserRole getUserRole() {
        return (OnenoteUserRole)((Object)this.backingStore.get("userRole"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("isDefault", this.getIsDefault());
        writer.writeBooleanValue("isShared", this.getIsShared());
        writer.writeObjectValue("links", (Parsable)this.getLinks(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("sectionGroups", this.getSectionGroups());
        writer.writeStringValue("sectionGroupsUrl", this.getSectionGroupsUrl());
        writer.writeCollectionOfObjectValues("sections", this.getSections());
        writer.writeStringValue("sectionsUrl", this.getSectionsUrl());
        writer.writeEnumValue("userRole", (Enum)this.getUserRole());
    }

    public void setIsDefault(@Nullable Boolean value) {
        this.backingStore.set("isDefault", (Object)value);
    }

    public void setIsShared(@Nullable Boolean value) {
        this.backingStore.set("isShared", (Object)value);
    }

    public void setLinks(@Nullable NotebookLinks value) {
        this.backingStore.set("links", (Object)value);
    }

    public void setSectionGroups(@Nullable List<SectionGroup> value) {
        this.backingStore.set("sectionGroups", value);
    }

    public void setSectionGroupsUrl(@Nullable String value) {
        this.backingStore.set("sectionGroupsUrl", (Object)value);
    }

    public void setSections(@Nullable List<OnenoteSection> value) {
        this.backingStore.set("sections", value);
    }

    public void setSectionsUrl(@Nullable String value) {
        this.backingStore.set("sectionsUrl", (Object)value);
    }

    public void setUserRole(@Nullable OnenoteUserRole value) {
        this.backingStore.set("userRole", (Object)value);
    }
}

