/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttributeMappingSource;
import com.microsoft.graph.models.PublicError;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ParseExpressionResponse
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ParseExpressionResponse() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ParseExpressionResponse createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ParseExpressionResponse();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Nullable
    public List<String> getEvaluationResult() {
        return (List)this.backingStore.get("evaluationResult");
    }

    @Nullable
    public Boolean getEvaluationSucceeded() {
        return (Boolean)this.backingStore.get("evaluationSucceeded");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("evaluationResult", n -> this.setEvaluationResult(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("evaluationSucceeded", n -> this.setEvaluationSucceeded(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("parsedExpression", n -> this.setParsedExpression((AttributeMappingSource)n.getObjectValue(AttributeMappingSource::createFromDiscriminatorValue)));
        deserializerMap.put("parsingSucceeded", n -> this.setParsingSucceeded(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public AttributeMappingSource getParsedExpression() {
        return (AttributeMappingSource)this.backingStore.get("parsedExpression");
    }

    @Nullable
    public Boolean getParsingSucceeded() {
        return (Boolean)this.backingStore.get("parsingSucceeded");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("evaluationResult", this.getEvaluationResult());
        writer.writeBooleanValue("evaluationSucceeded", this.getEvaluationSucceeded());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("parsedExpression", (Parsable)this.getParsedExpression(), new Parsable[0]);
        writer.writeBooleanValue("parsingSucceeded", this.getParsingSucceeded());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setEvaluationResult(@Nullable List<String> value) {
        this.backingStore.set("evaluationResult", value);
    }

    public void setEvaluationSucceeded(@Nullable Boolean value) {
        this.backingStore.set("evaluationSucceeded", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setParsedExpression(@Nullable AttributeMappingSource value) {
        this.backingStore.set("parsedExpression", (Object)value);
    }

    public void setParsingSucceeded(@Nullable Boolean value) {
        this.backingStore.set("parsingSucceeded", (Object)value);
    }
}

