/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IntegerRange;
import com.microsoft.graph.models.PrintColorMode;
import com.microsoft.graph.models.PrintDuplexMode;
import com.microsoft.graph.models.PrintFinishing;
import com.microsoft.graph.models.PrintMargin;
import com.microsoft.graph.models.PrintMultipageLayout;
import com.microsoft.graph.models.PrintOrientation;
import com.microsoft.graph.models.PrintQuality;
import com.microsoft.graph.models.PrintScaling;
import com.microsoft.graph.models.PrinterFeedOrientation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrintJobConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PrintJobConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PrintJobConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrintJobConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getCollate() {
        return (Boolean)this.backingStore.get("collate");
    }

    @Nullable
    public PrintColorMode getColorMode() {
        return (PrintColorMode)((Object)this.backingStore.get("colorMode"));
    }

    @Nullable
    public Integer getCopies() {
        return (Integer)this.backingStore.get("copies");
    }

    @Nullable
    public Integer getDpi() {
        return (Integer)this.backingStore.get("dpi");
    }

    @Nullable
    public PrintDuplexMode getDuplexMode() {
        return (PrintDuplexMode)((Object)this.backingStore.get("duplexMode"));
    }

    @Nullable
    public PrinterFeedOrientation getFeedOrientation() {
        return (PrinterFeedOrientation)((Object)this.backingStore.get("feedOrientation"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(20);
        deserializerMap.put("collate", n -> this.setCollate(n.getBooleanValue()));
        deserializerMap.put("colorMode", n -> this.setColorMode((PrintColorMode)n.getEnumValue(PrintColorMode::forValue)));
        deserializerMap.put("copies", n -> this.setCopies(n.getIntegerValue()));
        deserializerMap.put("dpi", n -> this.setDpi(n.getIntegerValue()));
        deserializerMap.put("duplexMode", n -> this.setDuplexMode((PrintDuplexMode)n.getEnumValue(PrintDuplexMode::forValue)));
        deserializerMap.put("feedOrientation", n -> this.setFeedOrientation((PrinterFeedOrientation)n.getEnumValue(PrinterFeedOrientation::forValue)));
        deserializerMap.put("finishings", n -> this.setFinishings(n.getCollectionOfEnumValues(PrintFinishing::forValue)));
        deserializerMap.put("fitPdfToPage", n -> this.setFitPdfToPage(n.getBooleanValue()));
        deserializerMap.put("inputBin", n -> this.setInputBin(n.getStringValue()));
        deserializerMap.put("margin", n -> this.setMargin((PrintMargin)n.getObjectValue(PrintMargin::createFromDiscriminatorValue)));
        deserializerMap.put("mediaSize", n -> this.setMediaSize(n.getStringValue()));
        deserializerMap.put("mediaType", n -> this.setMediaType(n.getStringValue()));
        deserializerMap.put("multipageLayout", n -> this.setMultipageLayout((PrintMultipageLayout)n.getEnumValue(PrintMultipageLayout::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("orientation", n -> this.setOrientation((PrintOrientation)n.getEnumValue(PrintOrientation::forValue)));
        deserializerMap.put("outputBin", n -> this.setOutputBin(n.getStringValue()));
        deserializerMap.put("pageRanges", n -> this.setPageRanges(n.getCollectionOfObjectValues(IntegerRange::createFromDiscriminatorValue)));
        deserializerMap.put("pagesPerSheet", n -> this.setPagesPerSheet(n.getIntegerValue()));
        deserializerMap.put("quality", n -> this.setQuality((PrintQuality)n.getEnumValue(PrintQuality::forValue)));
        deserializerMap.put("scaling", n -> this.setScaling((PrintScaling)n.getEnumValue(PrintScaling::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<PrintFinishing> getFinishings() {
        return (List)this.backingStore.get("finishings");
    }

    @Nullable
    public Boolean getFitPdfToPage() {
        return (Boolean)this.backingStore.get("fitPdfToPage");
    }

    @Nullable
    public String getInputBin() {
        return (String)this.backingStore.get("inputBin");
    }

    @Nullable
    public PrintMargin getMargin() {
        return (PrintMargin)this.backingStore.get("margin");
    }

    @Nullable
    public String getMediaSize() {
        return (String)this.backingStore.get("mediaSize");
    }

    @Nullable
    public String getMediaType() {
        return (String)this.backingStore.get("mediaType");
    }

    @Nullable
    public PrintMultipageLayout getMultipageLayout() {
        return (PrintMultipageLayout)((Object)this.backingStore.get("multipageLayout"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public PrintOrientation getOrientation() {
        return (PrintOrientation)((Object)this.backingStore.get("orientation"));
    }

    @Nullable
    public String getOutputBin() {
        return (String)this.backingStore.get("outputBin");
    }

    @Nullable
    public List<IntegerRange> getPageRanges() {
        return (List)this.backingStore.get("pageRanges");
    }

    @Nullable
    public Integer getPagesPerSheet() {
        return (Integer)this.backingStore.get("pagesPerSheet");
    }

    @Nullable
    public PrintQuality getQuality() {
        return (PrintQuality)((Object)this.backingStore.get("quality"));
    }

    @Nullable
    public PrintScaling getScaling() {
        return (PrintScaling)((Object)this.backingStore.get("scaling"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("collate", this.getCollate());
        writer.writeEnumValue("colorMode", (Enum)this.getColorMode());
        writer.writeIntegerValue("copies", this.getCopies());
        writer.writeIntegerValue("dpi", this.getDpi());
        writer.writeEnumValue("duplexMode", (Enum)this.getDuplexMode());
        writer.writeEnumValue("feedOrientation", (Enum)this.getFeedOrientation());
        writer.writeCollectionOfEnumValues("finishings", this.getFinishings());
        writer.writeBooleanValue("fitPdfToPage", this.getFitPdfToPage());
        writer.writeStringValue("inputBin", this.getInputBin());
        writer.writeObjectValue("margin", (Parsable)this.getMargin(), new Parsable[0]);
        writer.writeStringValue("mediaSize", this.getMediaSize());
        writer.writeStringValue("mediaType", this.getMediaType());
        writer.writeEnumValue("multipageLayout", (Enum)this.getMultipageLayout());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("orientation", (Enum)this.getOrientation());
        writer.writeStringValue("outputBin", this.getOutputBin());
        writer.writeCollectionOfObjectValues("pageRanges", this.getPageRanges());
        writer.writeIntegerValue("pagesPerSheet", this.getPagesPerSheet());
        writer.writeEnumValue("quality", (Enum)this.getQuality());
        writer.writeEnumValue("scaling", (Enum)this.getScaling());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCollate(@Nullable Boolean value) {
        this.backingStore.set("collate", (Object)value);
    }

    public void setColorMode(@Nullable PrintColorMode value) {
        this.backingStore.set("colorMode", (Object)value);
    }

    public void setCopies(@Nullable Integer value) {
        this.backingStore.set("copies", (Object)value);
    }

    public void setDpi(@Nullable Integer value) {
        this.backingStore.set("dpi", (Object)value);
    }

    public void setDuplexMode(@Nullable PrintDuplexMode value) {
        this.backingStore.set("duplexMode", (Object)value);
    }

    public void setFeedOrientation(@Nullable PrinterFeedOrientation value) {
        this.backingStore.set("feedOrientation", (Object)value);
    }

    public void setFinishings(@Nullable List<PrintFinishing> value) {
        this.backingStore.set("finishings", value);
    }

    public void setFitPdfToPage(@Nullable Boolean value) {
        this.backingStore.set("fitPdfToPage", (Object)value);
    }

    public void setInputBin(@Nullable String value) {
        this.backingStore.set("inputBin", (Object)value);
    }

    public void setMargin(@Nullable PrintMargin value) {
        this.backingStore.set("margin", (Object)value);
    }

    public void setMediaSize(@Nullable String value) {
        this.backingStore.set("mediaSize", (Object)value);
    }

    public void setMediaType(@Nullable String value) {
        this.backingStore.set("mediaType", (Object)value);
    }

    public void setMultipageLayout(@Nullable PrintMultipageLayout value) {
        this.backingStore.set("multipageLayout", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrientation(@Nullable PrintOrientation value) {
        this.backingStore.set("orientation", (Object)value);
    }

    public void setOutputBin(@Nullable String value) {
        this.backingStore.set("outputBin", (Object)value);
    }

    public void setPageRanges(@Nullable List<IntegerRange> value) {
        this.backingStore.set("pageRanges", value);
    }

    public void setPagesPerSheet(@Nullable Integer value) {
        this.backingStore.set("pagesPerSheet", (Object)value);
    }

    public void setQuality(@Nullable PrintQuality value) {
        this.backingStore.set("quality", (Object)value);
    }

    public void setScaling(@Nullable PrintScaling value) {
        this.backingStore.set("scaling", (Object)value);
    }
}

