/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.OnenoteSourceService;
import com.microsoft.graph.models.RecentNotebookLinks;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RecentNotebook
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RecentNotebook() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RecentNotebook createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RecentNotebook();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastAccessedTime", n -> this.setLastAccessedTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("links", n -> this.setLinks((RecentNotebookLinks)n.getObjectValue(RecentNotebookLinks::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("sourceService", n -> this.setSourceService((OnenoteSourceService)n.getEnumValue(OnenoteSourceService::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastAccessedTime() {
        return (OffsetDateTime)this.backingStore.get("lastAccessedTime");
    }

    @Nullable
    public RecentNotebookLinks getLinks() {
        return (RecentNotebookLinks)this.backingStore.get("links");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OnenoteSourceService getSourceService() {
        return (OnenoteSourceService)((Object)this.backingStore.get("sourceService"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastAccessedTime", this.getLastAccessedTime());
        writer.writeObjectValue("links", (Parsable)this.getLinks(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("sourceService", (Enum)this.getSourceService());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastAccessedTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastAccessedTime", (Object)value);
    }

    public void setLinks(@Nullable RecentNotebookLinks value) {
        this.backingStore.set("links", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSourceService(@Nullable OnenoteSourceService value) {
        this.backingStore.set("sourceService", (Object)value);
    }
}

