/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.OpenShiftItem;
import com.microsoft.graph.models.ScheduleEntity;
import com.microsoft.graph.models.ShiftActivity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ShiftItem
extends ScheduleEntity
implements Parsable {
    @Nonnull
    public static ShiftItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.openShiftItem": {
                    return new OpenShiftItem();
                }
            }
        }
        return new ShiftItem();
    }

    @Nullable
    public List<ShiftActivity> getActivities() {
        return (List)this.backingStore.get("activities");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activities", n -> this.setActivities(n.getCollectionOfObjectValues(ShiftActivity::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("notes", n -> this.setNotes(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getNotes() {
        return (String)this.backingStore.get("notes");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("activities", this.getActivities());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("notes", this.getNotes());
    }

    public void setActivities(@Nullable List<ShiftActivity> value) {
        this.backingStore.set("activities", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setNotes(@Nullable String value) {
        this.backingStore.set("notes", (Object)value);
    }
}

