/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Json;
import com.microsoft.graph.models.ServerProcessedContent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WebPartData
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WebPartData() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WebPartData createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WebPartData();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDataVersion() {
        return (String)this.backingStore.get("dataVersion");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("dataVersion", n -> this.setDataVersion(n.getStringValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("properties", n -> this.setProperties((Json)n.getObjectValue(Json::createFromDiscriminatorValue)));
        deserializerMap.put("serverProcessedContent", n -> this.setServerProcessedContent((ServerProcessedContent)n.getObjectValue(ServerProcessedContent::createFromDiscriminatorValue)));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Json getProperties() {
        return (Json)this.backingStore.get("properties");
    }

    @Nullable
    public ServerProcessedContent getServerProcessedContent() {
        return (ServerProcessedContent)this.backingStore.get("serverProcessedContent");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("dataVersion", this.getDataVersion());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("properties", (Parsable)this.getProperties(), new Parsable[0]);
        writer.writeObjectValue("serverProcessedContent", (Parsable)this.getServerProcessedContent(), new Parsable[0]);
        writer.writeStringValue("title", this.getTitle());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDataVersion(@Nullable String value) {
        this.backingStore.set("dataVersion", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProperties(@Nullable Json value) {
        this.backingStore.set("properties", (Object)value);
    }

    public void setServerProcessedContent(@Nullable ServerProcessedContent value) {
        this.backingStore.set("serverProcessedContent", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }
}

