/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.X509CertificateAffinityLevel;
import com.microsoft.graph.models.X509CertificateAuthenticationMode;
import com.microsoft.graph.models.X509CertificateRule;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class X509CertificateAuthenticationModeConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public X509CertificateAuthenticationModeConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static X509CertificateAuthenticationModeConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new X509CertificateAuthenticationModeConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("rules", n -> this.setRules(n.getCollectionOfObjectValues(X509CertificateRule::createFromDiscriminatorValue)));
        deserializerMap.put("x509CertificateAuthenticationDefaultMode", n -> this.setX509CertificateAuthenticationDefaultMode((X509CertificateAuthenticationMode)n.getEnumValue(X509CertificateAuthenticationMode::forValue)));
        deserializerMap.put("x509CertificateDefaultRequiredAffinityLevel", n -> this.setX509CertificateDefaultRequiredAffinityLevel((X509CertificateAffinityLevel)n.getEnumValue(X509CertificateAffinityLevel::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<X509CertificateRule> getRules() {
        return (List)this.backingStore.get("rules");
    }

    @Nullable
    public X509CertificateAuthenticationMode getX509CertificateAuthenticationDefaultMode() {
        return (X509CertificateAuthenticationMode)((Object)this.backingStore.get("x509CertificateAuthenticationDefaultMode"));
    }

    @Nullable
    public X509CertificateAffinityLevel getX509CertificateDefaultRequiredAffinityLevel() {
        return (X509CertificateAffinityLevel)((Object)this.backingStore.get("x509CertificateDefaultRequiredAffinityLevel"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("rules", this.getRules());
        writer.writeEnumValue("x509CertificateAuthenticationDefaultMode", (Enum)this.getX509CertificateAuthenticationDefaultMode());
        writer.writeEnumValue("x509CertificateDefaultRequiredAffinityLevel", (Enum)this.getX509CertificateDefaultRequiredAffinityLevel());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRules(@Nullable List<X509CertificateRule> value) {
        this.backingStore.set("rules", value);
    }

    public void setX509CertificateAuthenticationDefaultMode(@Nullable X509CertificateAuthenticationMode value) {
        this.backingStore.set("x509CertificateAuthenticationDefaultMode", (Object)value);
    }

    public void setX509CertificateDefaultRequiredAffinityLevel(@Nullable X509CertificateAffinityLevel value) {
        this.backingStore.set("x509CertificateDefaultRequiredAffinityLevel", (Object)value);
    }
}

