/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.X509CertificateAffinityLevel;
import com.microsoft.graph.models.X509CertificateAuthenticationMode;
import com.microsoft.graph.models.X509CertificateRuleType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class X509CertificateRule
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public X509CertificateRule() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static X509CertificateRule createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new X509CertificateRule();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("identifier", n -> this.setIdentifier(n.getStringValue()));
        deserializerMap.put("issuerSubjectIdentifier", n -> this.setIssuerSubjectIdentifier(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("policyOidIdentifier", n -> this.setPolicyOidIdentifier(n.getStringValue()));
        deserializerMap.put("x509CertificateAuthenticationMode", n -> this.setX509CertificateAuthenticationMode((X509CertificateAuthenticationMode)n.getEnumValue(X509CertificateAuthenticationMode::forValue)));
        deserializerMap.put("x509CertificateRequiredAffinityLevel", n -> this.setX509CertificateRequiredAffinityLevel((X509CertificateAffinityLevel)n.getEnumValue(X509CertificateAffinityLevel::forValue)));
        deserializerMap.put("x509CertificateRuleType", n -> this.setX509CertificateRuleType((X509CertificateRuleType)n.getEnumValue(X509CertificateRuleType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getIdentifier() {
        return (String)this.backingStore.get("identifier");
    }

    @Nullable
    public String getIssuerSubjectIdentifier() {
        return (String)this.backingStore.get("issuerSubjectIdentifier");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPolicyOidIdentifier() {
        return (String)this.backingStore.get("policyOidIdentifier");
    }

    @Nullable
    public X509CertificateAuthenticationMode getX509CertificateAuthenticationMode() {
        return (X509CertificateAuthenticationMode)((Object)this.backingStore.get("x509CertificateAuthenticationMode"));
    }

    @Nullable
    public X509CertificateAffinityLevel getX509CertificateRequiredAffinityLevel() {
        return (X509CertificateAffinityLevel)((Object)this.backingStore.get("x509CertificateRequiredAffinityLevel"));
    }

    @Nullable
    public X509CertificateRuleType getX509CertificateRuleType() {
        return (X509CertificateRuleType)((Object)this.backingStore.get("x509CertificateRuleType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("identifier", this.getIdentifier());
        writer.writeStringValue("issuerSubjectIdentifier", this.getIssuerSubjectIdentifier());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("policyOidIdentifier", this.getPolicyOidIdentifier());
        writer.writeEnumValue("x509CertificateAuthenticationMode", (Enum)this.getX509CertificateAuthenticationMode());
        writer.writeEnumValue("x509CertificateRequiredAffinityLevel", (Enum)this.getX509CertificateRequiredAffinityLevel());
        writer.writeEnumValue("x509CertificateRuleType", (Enum)this.getX509CertificateRuleType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIdentifier(@Nullable String value) {
        this.backingStore.set("identifier", (Object)value);
    }

    public void setIssuerSubjectIdentifier(@Nullable String value) {
        this.backingStore.set("issuerSubjectIdentifier", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPolicyOidIdentifier(@Nullable String value) {
        this.backingStore.set("policyOidIdentifier", (Object)value);
    }

    public void setX509CertificateAuthenticationMode(@Nullable X509CertificateAuthenticationMode value) {
        this.backingStore.set("x509CertificateAuthenticationMode", (Object)value);
    }

    public void setX509CertificateRequiredAffinityLevel(@Nullable X509CertificateAffinityLevel value) {
        this.backingStore.set("x509CertificateRequiredAffinityLevel", (Object)value);
    }

    public void setX509CertificateRuleType(@Nullable X509CertificateRuleType value) {
        this.backingStore.set("x509CertificateRuleType", (Object)value);
    }
}

