/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.identitygovernance.LifecycleWorkflowProcessingStatus;
import com.microsoft.graph.models.identitygovernance.TaskProcessingResult;
import com.microsoft.graph.models.identitygovernance.WorkflowExecutionType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserProcessingResult
extends Entity
implements Parsable {
    @Nonnull
    public static UserProcessingResult createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserProcessingResult();
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public Integer getFailedTasksCount() {
        return (Integer)this.backingStore.get("failedTasksCount");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("failedTasksCount", n -> this.setFailedTasksCount(n.getIntegerValue()));
        deserializerMap.put("processingStatus", n -> this.setProcessingStatus((LifecycleWorkflowProcessingStatus)n.getEnumValue(LifecycleWorkflowProcessingStatus::forValue)));
        deserializerMap.put("scheduledDateTime", n -> this.setScheduledDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("startedDateTime", n -> this.setStartedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("subject", n -> this.setSubject((User)n.getObjectValue(User::createFromDiscriminatorValue)));
        deserializerMap.put("taskProcessingResults", n -> this.setTaskProcessingResults(n.getCollectionOfObjectValues(TaskProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("totalTasksCount", n -> this.setTotalTasksCount(n.getIntegerValue()));
        deserializerMap.put("totalUnprocessedTasksCount", n -> this.setTotalUnprocessedTasksCount(n.getIntegerValue()));
        deserializerMap.put("workflowExecutionType", n -> this.setWorkflowExecutionType((WorkflowExecutionType)n.getEnumValue(WorkflowExecutionType::forValue)));
        deserializerMap.put("workflowVersion", n -> this.setWorkflowVersion(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public LifecycleWorkflowProcessingStatus getProcessingStatus() {
        return (LifecycleWorkflowProcessingStatus)((Object)this.backingStore.get("processingStatus"));
    }

    @Nullable
    public OffsetDateTime getScheduledDateTime() {
        return (OffsetDateTime)this.backingStore.get("scheduledDateTime");
    }

    @Nullable
    public OffsetDateTime getStartedDateTime() {
        return (OffsetDateTime)this.backingStore.get("startedDateTime");
    }

    @Nullable
    public User getSubject() {
        return (User)this.backingStore.get("subject");
    }

    @Nullable
    public List<TaskProcessingResult> getTaskProcessingResults() {
        return (List)this.backingStore.get("taskProcessingResults");
    }

    @Nullable
    public Integer getTotalTasksCount() {
        return (Integer)this.backingStore.get("totalTasksCount");
    }

    @Nullable
    public Integer getTotalUnprocessedTasksCount() {
        return (Integer)this.backingStore.get("totalUnprocessedTasksCount");
    }

    @Nullable
    public WorkflowExecutionType getWorkflowExecutionType() {
        return (WorkflowExecutionType)((Object)this.backingStore.get("workflowExecutionType"));
    }

    @Nullable
    public Integer getWorkflowVersion() {
        return (Integer)this.backingStore.get("workflowVersion");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeIntegerValue("failedTasksCount", this.getFailedTasksCount());
        writer.writeEnumValue("processingStatus", (Enum)this.getProcessingStatus());
        writer.writeOffsetDateTimeValue("scheduledDateTime", this.getScheduledDateTime());
        writer.writeOffsetDateTimeValue("startedDateTime", this.getStartedDateTime());
        writer.writeObjectValue("subject", (Parsable)this.getSubject(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("taskProcessingResults", this.getTaskProcessingResults());
        writer.writeIntegerValue("totalTasksCount", this.getTotalTasksCount());
        writer.writeIntegerValue("totalUnprocessedTasksCount", this.getTotalUnprocessedTasksCount());
        writer.writeEnumValue("workflowExecutionType", (Enum)this.getWorkflowExecutionType());
        writer.writeIntegerValue("workflowVersion", this.getWorkflowVersion());
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setFailedTasksCount(@Nullable Integer value) {
        this.backingStore.set("failedTasksCount", (Object)value);
    }

    public void setProcessingStatus(@Nullable LifecycleWorkflowProcessingStatus value) {
        this.backingStore.set("processingStatus", (Object)value);
    }

    public void setScheduledDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("scheduledDateTime", (Object)value);
    }

    public void setStartedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startedDateTime", (Object)value);
    }

    public void setSubject(@Nullable User value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setTaskProcessingResults(@Nullable List<TaskProcessingResult> value) {
        this.backingStore.set("taskProcessingResults", value);
    }

    public void setTotalTasksCount(@Nullable Integer value) {
        this.backingStore.set("totalTasksCount", (Object)value);
    }

    public void setTotalUnprocessedTasksCount(@Nullable Integer value) {
        this.backingStore.set("totalUnprocessedTasksCount", (Object)value);
    }

    public void setWorkflowExecutionType(@Nullable WorkflowExecutionType value) {
        this.backingStore.set("workflowExecutionType", (Object)value);
    }

    public void setWorkflowVersion(@Nullable Integer value) {
        this.backingStore.set("workflowVersion", (Object)value);
    }
}

