/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.communications.calls.item.answer;

import com.microsoft.graph.models.IncomingCallOptions;
import com.microsoft.graph.models.MediaConfig;
import com.microsoft.graph.models.Modality;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AnswerPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AnswerPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AnswerPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AnswerPostRequestBody();
    }

    @Nullable
    public List<Modality> getAcceptedModalities() {
        return (List)this.backingStore.get("acceptedModalities");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCallbackUri() {
        return (String)this.backingStore.get("callbackUri");
    }

    @Nullable
    public IncomingCallOptions getCallOptions() {
        return (IncomingCallOptions)this.backingStore.get("callOptions");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("acceptedModalities", n -> this.setAcceptedModalities(n.getCollectionOfEnumValues(Modality::forValue)));
        deserializerMap.put("callbackUri", n -> this.setCallbackUri(n.getStringValue()));
        deserializerMap.put("callOptions", n -> this.setCallOptions((IncomingCallOptions)n.getObjectValue(IncomingCallOptions::createFromDiscriminatorValue)));
        deserializerMap.put("mediaConfig", n -> this.setMediaConfig((MediaConfig)n.getObjectValue(MediaConfig::createFromDiscriminatorValue)));
        deserializerMap.put("participantCapacity", n -> this.setParticipantCapacity(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public MediaConfig getMediaConfig() {
        return (MediaConfig)this.backingStore.get("mediaConfig");
    }

    @Nullable
    public Integer getParticipantCapacity() {
        return (Integer)this.backingStore.get("participantCapacity");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfEnumValues("acceptedModalities", this.getAcceptedModalities());
        writer.writeStringValue("callbackUri", this.getCallbackUri());
        writer.writeObjectValue("callOptions", (Parsable)this.getCallOptions(), new Parsable[0]);
        writer.writeObjectValue("mediaConfig", (Parsable)this.getMediaConfig(), new Parsable[0]);
        writer.writeIntegerValue("participantCapacity", this.getParticipantCapacity());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAcceptedModalities(@Nullable List<Modality> value) {
        this.backingStore.set("acceptedModalities", value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCallbackUri(@Nullable String value) {
        this.backingStore.set("callbackUri", (Object)value);
    }

    public void setCallOptions(@Nullable IncomingCallOptions value) {
        this.backingStore.set("callOptions", (Object)value);
    }

    public void setMediaConfig(@Nullable MediaConfig value) {
        this.backingStore.set("mediaConfig", (Object)value);
    }

    public void setParticipantCapacity(@Nullable Integer value) {
        this.backingStore.set("participantCapacity", (Object)value);
    }
}

