/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackageLocalizedText;
import com.microsoft.graph.models.AccessPackageMultipleChoiceQuestion;
import com.microsoft.graph.models.AccessPackageTextInputQuestion;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageQuestion
extends Entity
implements Parsable {
    @Nonnull
    public static AccessPackageQuestion createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.accessPackageMultipleChoiceQuestion": {
                    return new AccessPackageMultipleChoiceQuestion();
                }
                case "#microsoft.graph.accessPackageTextInputQuestion": {
                    return new AccessPackageTextInputQuestion();
                }
            }
        }
        return new AccessPackageQuestion();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("isAnswerEditable", n -> this.setIsAnswerEditable(n.getBooleanValue()));
        deserializerMap.put("isRequired", n -> this.setIsRequired(n.getBooleanValue()));
        deserializerMap.put("localizations", n -> this.setLocalizations(n.getCollectionOfObjectValues(AccessPackageLocalizedText::createFromDiscriminatorValue)));
        deserializerMap.put("sequence", n -> this.setSequence(n.getIntegerValue()));
        deserializerMap.put("text", n -> this.setText(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAnswerEditable() {
        return (Boolean)this.backingStore.get("isAnswerEditable");
    }

    @Nullable
    public Boolean getIsRequired() {
        return (Boolean)this.backingStore.get("isRequired");
    }

    @Nullable
    public List<AccessPackageLocalizedText> getLocalizations() {
        return (List)this.backingStore.get("localizations");
    }

    @Nullable
    public Integer getSequence() {
        return (Integer)this.backingStore.get("sequence");
    }

    @Nullable
    public String getText() {
        return (String)this.backingStore.get("text");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("isAnswerEditable", this.getIsAnswerEditable());
        writer.writeBooleanValue("isRequired", this.getIsRequired());
        writer.writeCollectionOfObjectValues("localizations", this.getLocalizations());
        writer.writeIntegerValue("sequence", this.getSequence());
        writer.writeStringValue("text", this.getText());
    }

    public void setIsAnswerEditable(@Nullable Boolean value) {
        this.backingStore.set("isAnswerEditable", (Object)value);
    }

    public void setIsRequired(@Nullable Boolean value) {
        this.backingStore.set("isRequired", (Object)value);
    }

    public void setLocalizations(@Nullable List<AccessPackageLocalizedText> value) {
        this.backingStore.set("localizations", value);
    }

    public void setSequence(@Nullable Integer value) {
        this.backingStore.set("sequence", (Object)value);
    }

    public void setText(@Nullable String value) {
        this.backingStore.set("text", (Object)value);
    }
}

