/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Audio
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Audio() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Audio createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Audio();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAlbum() {
        return (String)this.backingStore.get("album");
    }

    @Nullable
    public String getAlbumArtist() {
        return (String)this.backingStore.get("albumArtist");
    }

    @Nullable
    public String getArtist() {
        return (String)this.backingStore.get("artist");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getBitrate() {
        return (Long)this.backingStore.get("bitrate");
    }

    @Nullable
    public String getComposers() {
        return (String)this.backingStore.get("composers");
    }

    @Nullable
    public String getCopyright() {
        return (String)this.backingStore.get("copyright");
    }

    @Nullable
    public Integer getDisc() {
        return (Integer)this.backingStore.get("disc");
    }

    @Nullable
    public Integer getDiscCount() {
        return (Integer)this.backingStore.get("discCount");
    }

    @Nullable
    public Long getDuration() {
        return (Long)this.backingStore.get("duration");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(17);
        deserializerMap.put("album", n -> this.setAlbum(n.getStringValue()));
        deserializerMap.put("albumArtist", n -> this.setAlbumArtist(n.getStringValue()));
        deserializerMap.put("artist", n -> this.setArtist(n.getStringValue()));
        deserializerMap.put("bitrate", n -> this.setBitrate(n.getLongValue()));
        deserializerMap.put("composers", n -> this.setComposers(n.getStringValue()));
        deserializerMap.put("copyright", n -> this.setCopyright(n.getStringValue()));
        deserializerMap.put("disc", n -> this.setDisc(n.getIntegerValue()));
        deserializerMap.put("discCount", n -> this.setDiscCount(n.getIntegerValue()));
        deserializerMap.put("duration", n -> this.setDuration(n.getLongValue()));
        deserializerMap.put("genre", n -> this.setGenre(n.getStringValue()));
        deserializerMap.put("hasDrm", n -> this.setHasDrm(n.getBooleanValue()));
        deserializerMap.put("isVariableBitrate", n -> this.setIsVariableBitrate(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        deserializerMap.put("track", n -> this.setTrack(n.getIntegerValue()));
        deserializerMap.put("trackCount", n -> this.setTrackCount(n.getIntegerValue()));
        deserializerMap.put("year", n -> this.setYear(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public String getGenre() {
        return (String)this.backingStore.get("genre");
    }

    @Nullable
    public Boolean getHasDrm() {
        return (Boolean)this.backingStore.get("hasDrm");
    }

    @Nullable
    public Boolean getIsVariableBitrate() {
        return (Boolean)this.backingStore.get("isVariableBitrate");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Nullable
    public Integer getTrack() {
        return (Integer)this.backingStore.get("track");
    }

    @Nullable
    public Integer getTrackCount() {
        return (Integer)this.backingStore.get("trackCount");
    }

    @Nullable
    public Integer getYear() {
        return (Integer)this.backingStore.get("year");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("album", this.getAlbum());
        writer.writeStringValue("albumArtist", this.getAlbumArtist());
        writer.writeStringValue("artist", this.getArtist());
        writer.writeLongValue("bitrate", this.getBitrate());
        writer.writeStringValue("composers", this.getComposers());
        writer.writeStringValue("copyright", this.getCopyright());
        writer.writeIntegerValue("disc", this.getDisc());
        writer.writeIntegerValue("discCount", this.getDiscCount());
        writer.writeLongValue("duration", this.getDuration());
        writer.writeStringValue("genre", this.getGenre());
        writer.writeBooleanValue("hasDrm", this.getHasDrm());
        writer.writeBooleanValue("isVariableBitrate", this.getIsVariableBitrate());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("title", this.getTitle());
        writer.writeIntegerValue("track", this.getTrack());
        writer.writeIntegerValue("trackCount", this.getTrackCount());
        writer.writeIntegerValue("year", this.getYear());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAlbum(@Nullable String value) {
        this.backingStore.set("album", (Object)value);
    }

    public void setAlbumArtist(@Nullable String value) {
        this.backingStore.set("albumArtist", (Object)value);
    }

    public void setArtist(@Nullable String value) {
        this.backingStore.set("artist", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBitrate(@Nullable Long value) {
        this.backingStore.set("bitrate", (Object)value);
    }

    public void setComposers(@Nullable String value) {
        this.backingStore.set("composers", (Object)value);
    }

    public void setCopyright(@Nullable String value) {
        this.backingStore.set("copyright", (Object)value);
    }

    public void setDisc(@Nullable Integer value) {
        this.backingStore.set("disc", (Object)value);
    }

    public void setDiscCount(@Nullable Integer value) {
        this.backingStore.set("discCount", (Object)value);
    }

    public void setDuration(@Nullable Long value) {
        this.backingStore.set("duration", (Object)value);
    }

    public void setGenre(@Nullable String value) {
        this.backingStore.set("genre", (Object)value);
    }

    public void setHasDrm(@Nullable Boolean value) {
        this.backingStore.set("hasDrm", (Object)value);
    }

    public void setIsVariableBitrate(@Nullable Boolean value) {
        this.backingStore.set("isVariableBitrate", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }

    public void setTrack(@Nullable Integer value) {
        this.backingStore.set("track", (Object)value);
    }

    public void setTrackCount(@Nullable Integer value) {
        this.backingStore.set("trackCount", (Object)value);
    }

    public void setYear(@Nullable Integer value) {
        this.backingStore.set("year", (Object)value);
    }
}

