/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationAttributeCollectionInputType;
import com.microsoft.graph.models.AuthenticationAttributeCollectionOptionConfiguration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AuthenticationAttributeCollectionInputConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AuthenticationAttributeCollectionInputConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AuthenticationAttributeCollectionInputConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AuthenticationAttributeCollectionInputConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAttribute() {
        return (String)this.backingStore.get("attribute");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDefaultValue() {
        return (String)this.backingStore.get("defaultValue");
    }

    @Nullable
    public Boolean getEditable() {
        return (Boolean)this.backingStore.get("editable");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(11);
        deserializerMap.put("attribute", n -> this.setAttribute(n.getStringValue()));
        deserializerMap.put("defaultValue", n -> this.setDefaultValue(n.getStringValue()));
        deserializerMap.put("editable", n -> this.setEditable(n.getBooleanValue()));
        deserializerMap.put("hidden", n -> this.setHidden(n.getBooleanValue()));
        deserializerMap.put("inputType", n -> this.setInputType((AuthenticationAttributeCollectionInputType)n.getEnumValue(AuthenticationAttributeCollectionInputType::forValue)));
        deserializerMap.put("label", n -> this.setLabel(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("options", n -> this.setOptions(n.getCollectionOfObjectValues(AuthenticationAttributeCollectionOptionConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("required", n -> this.setRequired(n.getBooleanValue()));
        deserializerMap.put("validationRegEx", n -> this.setValidationRegEx(n.getStringValue()));
        deserializerMap.put("writeToDirectory", n -> this.setWriteToDirectory(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHidden() {
        return (Boolean)this.backingStore.get("hidden");
    }

    @Nullable
    public AuthenticationAttributeCollectionInputType getInputType() {
        return (AuthenticationAttributeCollectionInputType)((Object)this.backingStore.get("inputType"));
    }

    @Nullable
    public String getLabel() {
        return (String)this.backingStore.get("label");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<AuthenticationAttributeCollectionOptionConfiguration> getOptions() {
        return (List)this.backingStore.get("options");
    }

    @Nullable
    public Boolean getRequired() {
        return (Boolean)this.backingStore.get("required");
    }

    @Nullable
    public String getValidationRegEx() {
        return (String)this.backingStore.get("validationRegEx");
    }

    @Nullable
    public Boolean getWriteToDirectory() {
        return (Boolean)this.backingStore.get("writeToDirectory");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("attribute", this.getAttribute());
        writer.writeStringValue("defaultValue", this.getDefaultValue());
        writer.writeBooleanValue("editable", this.getEditable());
        writer.writeBooleanValue("hidden", this.getHidden());
        writer.writeEnumValue("inputType", (Enum)this.getInputType());
        writer.writeStringValue("label", this.getLabel());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("options", this.getOptions());
        writer.writeBooleanValue("required", this.getRequired());
        writer.writeStringValue("validationRegEx", this.getValidationRegEx());
        writer.writeBooleanValue("writeToDirectory", this.getWriteToDirectory());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAttribute(@Nullable String value) {
        this.backingStore.set("attribute", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDefaultValue(@Nullable String value) {
        this.backingStore.set("defaultValue", (Object)value);
    }

    public void setEditable(@Nullable Boolean value) {
        this.backingStore.set("editable", (Object)value);
    }

    public void setHidden(@Nullable Boolean value) {
        this.backingStore.set("hidden", (Object)value);
    }

    public void setInputType(@Nullable AuthenticationAttributeCollectionInputType value) {
        this.backingStore.set("inputType", (Object)value);
    }

    public void setLabel(@Nullable String value) {
        this.backingStore.set("label", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOptions(@Nullable List<AuthenticationAttributeCollectionOptionConfiguration> value) {
        this.backingStore.set("options", value);
    }

    public void setRequired(@Nullable Boolean value) {
        this.backingStore.set("required", (Object)value);
    }

    public void setValidationRegEx(@Nullable String value) {
        this.backingStore.set("validationRegEx", (Object)value);
    }

    public void setWriteToDirectory(@Nullable Boolean value) {
        this.backingStore.set("writeToDirectory", (Object)value);
    }
}

