/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CalendarColor;
import com.microsoft.graph.models.CalendarPermission;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.OnlineMeetingProviderType;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Calendar
extends Entity
implements Parsable {
    @Nonnull
    public static Calendar createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Calendar();
    }

    @Nullable
    public List<OnlineMeetingProviderType> getAllowedOnlineMeetingProviders() {
        return (List)this.backingStore.get("allowedOnlineMeetingProviders");
    }

    @Nullable
    public List<CalendarPermission> getCalendarPermissions() {
        return (List)this.backingStore.get("calendarPermissions");
    }

    @Nullable
    public List<Event> getCalendarView() {
        return (List)this.backingStore.get("calendarView");
    }

    @Nullable
    public Boolean getCanEdit() {
        return (Boolean)this.backingStore.get("canEdit");
    }

    @Nullable
    public Boolean getCanShare() {
        return (Boolean)this.backingStore.get("canShare");
    }

    @Nullable
    public Boolean getCanViewPrivateItems() {
        return (Boolean)this.backingStore.get("canViewPrivateItems");
    }

    @Nullable
    public String getChangeKey() {
        return (String)this.backingStore.get("changeKey");
    }

    @Nullable
    public CalendarColor getColor() {
        return (CalendarColor)((Object)this.backingStore.get("color"));
    }

    @Nullable
    public OnlineMeetingProviderType getDefaultOnlineMeetingProvider() {
        return (OnlineMeetingProviderType)((Object)this.backingStore.get("defaultOnlineMeetingProvider"));
    }

    @Nullable
    public List<Event> getEvents() {
        return (List)this.backingStore.get("events");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedOnlineMeetingProviders", n -> this.setAllowedOnlineMeetingProviders(n.getCollectionOfEnumValues(OnlineMeetingProviderType::forValue)));
        deserializerMap.put("calendarPermissions", n -> this.setCalendarPermissions(n.getCollectionOfObjectValues(CalendarPermission::createFromDiscriminatorValue)));
        deserializerMap.put("calendarView", n -> this.setCalendarView(n.getCollectionOfObjectValues(Event::createFromDiscriminatorValue)));
        deserializerMap.put("canEdit", n -> this.setCanEdit(n.getBooleanValue()));
        deserializerMap.put("canShare", n -> this.setCanShare(n.getBooleanValue()));
        deserializerMap.put("canViewPrivateItems", n -> this.setCanViewPrivateItems(n.getBooleanValue()));
        deserializerMap.put("changeKey", n -> this.setChangeKey(n.getStringValue()));
        deserializerMap.put("color", n -> this.setColor((CalendarColor)n.getEnumValue(CalendarColor::forValue)));
        deserializerMap.put("defaultOnlineMeetingProvider", n -> this.setDefaultOnlineMeetingProvider((OnlineMeetingProviderType)n.getEnumValue(OnlineMeetingProviderType::forValue)));
        deserializerMap.put("events", n -> this.setEvents(n.getCollectionOfObjectValues(Event::createFromDiscriminatorValue)));
        deserializerMap.put("hexColor", n -> this.setHexColor(n.getStringValue()));
        deserializerMap.put("isDefaultCalendar", n -> this.setIsDefaultCalendar(n.getBooleanValue()));
        deserializerMap.put("isRemovable", n -> this.setIsRemovable(n.getBooleanValue()));
        deserializerMap.put("isTallyingResponses", n -> this.setIsTallyingResponses(n.getBooleanValue()));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("owner", n -> this.setOwner((EmailAddress)n.getObjectValue(EmailAddress::createFromDiscriminatorValue)));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getHexColor() {
        return (String)this.backingStore.get("hexColor");
    }

    @Nullable
    public Boolean getIsDefaultCalendar() {
        return (Boolean)this.backingStore.get("isDefaultCalendar");
    }

    @Nullable
    public Boolean getIsRemovable() {
        return (Boolean)this.backingStore.get("isRemovable");
    }

    @Nullable
    public Boolean getIsTallyingResponses() {
        return (Boolean)this.backingStore.get("isTallyingResponses");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public EmailAddress getOwner() {
        return (EmailAddress)this.backingStore.get("owner");
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfEnumValues("allowedOnlineMeetingProviders", this.getAllowedOnlineMeetingProviders());
        writer.writeCollectionOfObjectValues("calendarPermissions", this.getCalendarPermissions());
        writer.writeCollectionOfObjectValues("calendarView", this.getCalendarView());
        writer.writeBooleanValue("canEdit", this.getCanEdit());
        writer.writeBooleanValue("canShare", this.getCanShare());
        writer.writeBooleanValue("canViewPrivateItems", this.getCanViewPrivateItems());
        writer.writeStringValue("changeKey", this.getChangeKey());
        writer.writeEnumValue("color", (Enum)this.getColor());
        writer.writeEnumValue("defaultOnlineMeetingProvider", (Enum)this.getDefaultOnlineMeetingProvider());
        writer.writeCollectionOfObjectValues("events", this.getEvents());
        writer.writeStringValue("hexColor", this.getHexColor());
        writer.writeBooleanValue("isDefaultCalendar", this.getIsDefaultCalendar());
        writer.writeBooleanValue("isRemovable", this.getIsRemovable());
        writer.writeBooleanValue("isTallyingResponses", this.getIsTallyingResponses());
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeStringValue("name", this.getName());
        writer.writeObjectValue("owner", (Parsable)this.getOwner(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
    }

    public void setAllowedOnlineMeetingProviders(@Nullable List<OnlineMeetingProviderType> value) {
        this.backingStore.set("allowedOnlineMeetingProviders", value);
    }

    public void setCalendarPermissions(@Nullable List<CalendarPermission> value) {
        this.backingStore.set("calendarPermissions", value);
    }

    public void setCalendarView(@Nullable List<Event> value) {
        this.backingStore.set("calendarView", value);
    }

    public void setCanEdit(@Nullable Boolean value) {
        this.backingStore.set("canEdit", (Object)value);
    }

    public void setCanShare(@Nullable Boolean value) {
        this.backingStore.set("canShare", (Object)value);
    }

    public void setCanViewPrivateItems(@Nullable Boolean value) {
        this.backingStore.set("canViewPrivateItems", (Object)value);
    }

    public void setChangeKey(@Nullable String value) {
        this.backingStore.set("changeKey", (Object)value);
    }

    public void setColor(@Nullable CalendarColor value) {
        this.backingStore.set("color", (Object)value);
    }

    public void setDefaultOnlineMeetingProvider(@Nullable OnlineMeetingProviderType value) {
        this.backingStore.set("defaultOnlineMeetingProvider", (Object)value);
    }

    public void setEvents(@Nullable List<Event> value) {
        this.backingStore.set("events", value);
    }

    public void setHexColor(@Nullable String value) {
        this.backingStore.set("hexColor", (Object)value);
    }

    public void setIsDefaultCalendar(@Nullable Boolean value) {
        this.backingStore.set("isDefaultCalendar", (Object)value);
    }

    public void setIsRemovable(@Nullable Boolean value) {
        this.backingStore.set("isRemovable", (Object)value);
    }

    public void setIsTallyingResponses(@Nullable Boolean value) {
        this.backingStore.set("isTallyingResponses", (Object)value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOwner(@Nullable EmailAddress value) {
        this.backingStore.set("owner", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }
}

