/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DelegatedAdminAccessAssignment;
import com.microsoft.graph.models.DelegatedAdminAccessDetails;
import com.microsoft.graph.models.DelegatedAdminRelationshipCustomerParticipant;
import com.microsoft.graph.models.DelegatedAdminRelationshipOperation;
import com.microsoft.graph.models.DelegatedAdminRelationshipRequest;
import com.microsoft.graph.models.DelegatedAdminRelationshipStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ResellerDelegatedAdminRelationship;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DelegatedAdminRelationship
extends Entity
implements Parsable {
    @Nonnull
    public static DelegatedAdminRelationship createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.resellerDelegatedAdminRelationship": {
                    return new ResellerDelegatedAdminRelationship();
                }
            }
        }
        return new DelegatedAdminRelationship();
    }

    @Nullable
    public List<DelegatedAdminAccessAssignment> getAccessAssignments() {
        return (List)this.backingStore.get("accessAssignments");
    }

    @Nullable
    public DelegatedAdminAccessDetails getAccessDetails() {
        return (DelegatedAdminAccessDetails)this.backingStore.get("accessDetails");
    }

    @Nullable
    public OffsetDateTime getActivatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("activatedDateTime");
    }

    @Nullable
    public PeriodAndDuration getAutoExtendDuration() {
        return (PeriodAndDuration)this.backingStore.get("autoExtendDuration");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public DelegatedAdminRelationshipCustomerParticipant getCustomer() {
        return (DelegatedAdminRelationshipCustomerParticipant)this.backingStore.get("customer");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public PeriodAndDuration getDuration() {
        return (PeriodAndDuration)this.backingStore.get("duration");
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accessAssignments", n -> this.setAccessAssignments(n.getCollectionOfObjectValues(DelegatedAdminAccessAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("accessDetails", n -> this.setAccessDetails((DelegatedAdminAccessDetails)n.getObjectValue(DelegatedAdminAccessDetails::createFromDiscriminatorValue)));
        deserializerMap.put("activatedDateTime", n -> this.setActivatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("autoExtendDuration", n -> this.setAutoExtendDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customer", n -> this.setCustomer((DelegatedAdminRelationshipCustomerParticipant)n.getObjectValue(DelegatedAdminRelationshipCustomerParticipant::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("duration", n -> this.setDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(DelegatedAdminRelationshipOperation::createFromDiscriminatorValue)));
        deserializerMap.put("requests", n -> this.setRequests(n.getCollectionOfObjectValues(DelegatedAdminRelationshipRequest::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((DelegatedAdminRelationshipStatus)n.getEnumValue(DelegatedAdminRelationshipStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<DelegatedAdminRelationshipOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public List<DelegatedAdminRelationshipRequest> getRequests() {
        return (List)this.backingStore.get("requests");
    }

    @Nullable
    public DelegatedAdminRelationshipStatus getStatus() {
        return (DelegatedAdminRelationshipStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("accessAssignments", this.getAccessAssignments());
        writer.writeObjectValue("accessDetails", (Parsable)this.getAccessDetails(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("activatedDateTime", this.getActivatedDateTime());
        writer.writePeriodAndDurationValue("autoExtendDuration", this.getAutoExtendDuration());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("customer", (Parsable)this.getCustomer(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writePeriodAndDurationValue("duration", this.getDuration());
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeCollectionOfObjectValues("requests", this.getRequests());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setAccessAssignments(@Nullable List<DelegatedAdminAccessAssignment> value) {
        this.backingStore.set("accessAssignments", value);
    }

    public void setAccessDetails(@Nullable DelegatedAdminAccessDetails value) {
        this.backingStore.set("accessDetails", (Object)value);
    }

    public void setActivatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("activatedDateTime", (Object)value);
    }

    public void setAutoExtendDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("autoExtendDuration", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomer(@Nullable DelegatedAdminRelationshipCustomerParticipant value) {
        this.backingStore.set("customer", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("duration", (Object)value);
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setOperations(@Nullable List<DelegatedAdminRelationshipOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setRequests(@Nullable List<DelegatedAdminRelationshipRequest> value) {
        this.backingStore.set("requests", value);
    }

    public void setStatus(@Nullable DelegatedAdminRelationshipStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

