/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceEnrollmentPlatformRestriction
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceEnrollmentPlatformRestriction() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceEnrollmentPlatformRestriction createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceEnrollmentPlatformRestriction();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("osMaximumVersion", n -> this.setOsMaximumVersion(n.getStringValue()));
        deserializerMap.put("osMinimumVersion", n -> this.setOsMinimumVersion(n.getStringValue()));
        deserializerMap.put("personalDeviceEnrollmentBlocked", n -> this.setPersonalDeviceEnrollmentBlocked(n.getBooleanValue()));
        deserializerMap.put("platformBlocked", n -> this.setPlatformBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOsMaximumVersion() {
        return (String)this.backingStore.get("osMaximumVersion");
    }

    @Nullable
    public String getOsMinimumVersion() {
        return (String)this.backingStore.get("osMinimumVersion");
    }

    @Nullable
    public Boolean getPersonalDeviceEnrollmentBlocked() {
        return (Boolean)this.backingStore.get("personalDeviceEnrollmentBlocked");
    }

    @Nullable
    public Boolean getPlatformBlocked() {
        return (Boolean)this.backingStore.get("platformBlocked");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("osMaximumVersion", this.getOsMaximumVersion());
        writer.writeStringValue("osMinimumVersion", this.getOsMinimumVersion());
        writer.writeBooleanValue("personalDeviceEnrollmentBlocked", this.getPersonalDeviceEnrollmentBlocked());
        writer.writeBooleanValue("platformBlocked", this.getPlatformBlocked());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOsMaximumVersion(@Nullable String value) {
        this.backingStore.set("osMaximumVersion", (Object)value);
    }

    public void setOsMinimumVersion(@Nullable String value) {
        this.backingStore.set("osMinimumVersion", (Object)value);
    }

    public void setPersonalDeviceEnrollmentBlocked(@Nullable Boolean value) {
        this.backingStore.set("personalDeviceEnrollmentBlocked", (Object)value);
    }

    public void setPlatformBlocked(@Nullable Boolean value) {
        this.backingStore.set("platformBlocked", (Object)value);
    }
}

