/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MediaDirection;
import com.microsoft.graph.models.Modality;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MediaStream
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MediaStream() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MediaStream createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MediaStream();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public MediaDirection getDirection() {
        return (MediaDirection)((Object)this.backingStore.get("direction"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("direction", n -> this.setDirection((MediaDirection)n.getEnumValue(MediaDirection::forValue)));
        deserializerMap.put("label", n -> this.setLabel(n.getStringValue()));
        deserializerMap.put("mediaType", n -> this.setMediaType((Modality)n.getEnumValue(Modality::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("serverMuted", n -> this.setServerMuted(n.getBooleanValue()));
        deserializerMap.put("sourceId", n -> this.setSourceId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getLabel() {
        return (String)this.backingStore.get("label");
    }

    @Nullable
    public Modality getMediaType() {
        return (Modality)((Object)this.backingStore.get("mediaType"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getServerMuted() {
        return (Boolean)this.backingStore.get("serverMuted");
    }

    @Nullable
    public String getSourceId() {
        return (String)this.backingStore.get("sourceId");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("direction", (Enum)this.getDirection());
        writer.writeStringValue("label", this.getLabel());
        writer.writeEnumValue("mediaType", (Enum)this.getMediaType());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("serverMuted", this.getServerMuted());
        writer.writeStringValue("sourceId", this.getSourceId());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDirection(@Nullable MediaDirection value) {
        this.backingStore.set("direction", (Object)value);
    }

    public void setLabel(@Nullable String value) {
        this.backingStore.set("label", (Object)value);
    }

    public void setMediaType(@Nullable Modality value) {
        this.backingStore.set("mediaType", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setServerMuted(@Nullable Boolean value) {
        this.backingStore.set("serverMuted", (Object)value);
    }

    public void setSourceId(@Nullable String value) {
        this.backingStore.set("sourceId", (Object)value);
    }
}

