/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MessageSecurityState
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MessageSecurityState() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MessageSecurityState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MessageSecurityState();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getConnectingIP() {
        return (String)this.backingStore.get("connectingIP");
    }

    @Nullable
    public String getDeliveryAction() {
        return (String)this.backingStore.get("deliveryAction");
    }

    @Nullable
    public String getDeliveryLocation() {
        return (String)this.backingStore.get("deliveryLocation");
    }

    @Nullable
    public String getDirectionality() {
        return (String)this.backingStore.get("directionality");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("connectingIP", n -> this.setConnectingIP(n.getStringValue()));
        deserializerMap.put("deliveryAction", n -> this.setDeliveryAction(n.getStringValue()));
        deserializerMap.put("deliveryLocation", n -> this.setDeliveryLocation(n.getStringValue()));
        deserializerMap.put("directionality", n -> this.setDirectionality(n.getStringValue()));
        deserializerMap.put("internetMessageId", n -> this.setInternetMessageId(n.getStringValue()));
        deserializerMap.put("messageFingerprint", n -> this.setMessageFingerprint(n.getStringValue()));
        deserializerMap.put("messageReceivedDateTime", n -> this.setMessageReceivedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("messageSubject", n -> this.setMessageSubject(n.getStringValue()));
        deserializerMap.put("networkMessageId", n -> this.setNetworkMessageId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getInternetMessageId() {
        return (String)this.backingStore.get("internetMessageId");
    }

    @Nullable
    public String getMessageFingerprint() {
        return (String)this.backingStore.get("messageFingerprint");
    }

    @Nullable
    public OffsetDateTime getMessageReceivedDateTime() {
        return (OffsetDateTime)this.backingStore.get("messageReceivedDateTime");
    }

    @Nullable
    public String getMessageSubject() {
        return (String)this.backingStore.get("messageSubject");
    }

    @Nullable
    public String getNetworkMessageId() {
        return (String)this.backingStore.get("networkMessageId");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("connectingIP", this.getConnectingIP());
        writer.writeStringValue("deliveryAction", this.getDeliveryAction());
        writer.writeStringValue("deliveryLocation", this.getDeliveryLocation());
        writer.writeStringValue("directionality", this.getDirectionality());
        writer.writeStringValue("internetMessageId", this.getInternetMessageId());
        writer.writeStringValue("messageFingerprint", this.getMessageFingerprint());
        writer.writeOffsetDateTimeValue("messageReceivedDateTime", this.getMessageReceivedDateTime());
        writer.writeStringValue("messageSubject", this.getMessageSubject());
        writer.writeStringValue("networkMessageId", this.getNetworkMessageId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConnectingIP(@Nullable String value) {
        this.backingStore.set("connectingIP", (Object)value);
    }

    public void setDeliveryAction(@Nullable String value) {
        this.backingStore.set("deliveryAction", (Object)value);
    }

    public void setDeliveryLocation(@Nullable String value) {
        this.backingStore.set("deliveryLocation", (Object)value);
    }

    public void setDirectionality(@Nullable String value) {
        this.backingStore.set("directionality", (Object)value);
    }

    public void setInternetMessageId(@Nullable String value) {
        this.backingStore.set("internetMessageId", (Object)value);
    }

    public void setMessageFingerprint(@Nullable String value) {
        this.backingStore.set("messageFingerprint", (Object)value);
    }

    public void setMessageReceivedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("messageReceivedDateTime", (Object)value);
    }

    public void setMessageSubject(@Nullable String value) {
        this.backingStore.set("messageSubject", (Object)value);
    }

    public void setNetworkMessageId(@Nullable String value) {
        this.backingStore.set("networkMessageId", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

