/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrinterBase;
import com.microsoft.graph.models.PrinterShareViewpoint;
import com.microsoft.graph.models.User;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrinterShare
extends PrinterBase
implements Parsable {
    public PrinterShare() {
        this.setOdataType("#microsoft.graph.printerShare");
    }

    @Nonnull
    public static PrinterShare createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrinterShare();
    }

    @Nullable
    public Boolean getAllowAllUsers() {
        return (Boolean)this.backingStore.get("allowAllUsers");
    }

    @Nullable
    public List<Group> getAllowedGroups() {
        return (List)this.backingStore.get("allowedGroups");
    }

    @Nullable
    public List<User> getAllowedUsers() {
        return (List)this.backingStore.get("allowedUsers");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowAllUsers", n -> this.setAllowAllUsers(n.getBooleanValue()));
        deserializerMap.put("allowedGroups", n -> this.setAllowedGroups(n.getCollectionOfObjectValues(Group::createFromDiscriminatorValue)));
        deserializerMap.put("allowedUsers", n -> this.setAllowedUsers(n.getCollectionOfObjectValues(User::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("printer", n -> this.setPrinter((Printer)n.getObjectValue(Printer::createFromDiscriminatorValue)));
        deserializerMap.put("viewPoint", n -> this.setViewPoint((PrinterShareViewpoint)n.getObjectValue(PrinterShareViewpoint::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Printer getPrinter() {
        return (Printer)this.backingStore.get("printer");
    }

    @Nullable
    public PrinterShareViewpoint getViewPoint() {
        return (PrinterShareViewpoint)this.backingStore.get("viewPoint");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("allowAllUsers", this.getAllowAllUsers());
        writer.writeCollectionOfObjectValues("allowedGroups", this.getAllowedGroups());
        writer.writeCollectionOfObjectValues("allowedUsers", this.getAllowedUsers());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("printer", (Parsable)this.getPrinter(), new Parsable[0]);
        writer.writeObjectValue("viewPoint", (Parsable)this.getViewPoint(), new Parsable[0]);
    }

    public void setAllowAllUsers(@Nullable Boolean value) {
        this.backingStore.set("allowAllUsers", (Object)value);
    }

    public void setAllowedGroups(@Nullable List<Group> value) {
        this.backingStore.set("allowedGroups", value);
    }

    public void setAllowedUsers(@Nullable List<User> value) {
        this.backingStore.set("allowedUsers", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setPrinter(@Nullable Printer value) {
        this.backingStore.set("printer", (Object)value);
    }

    public void setViewPoint(@Nullable PrinterShareViewpoint value) {
        this.backingStore.set("viewPoint", (Object)value);
    }
}

