/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentScheduleRequest;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequest;
import com.microsoft.graph.models.PrivilegedAccessScheduleRequest;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleRequest;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleRequest;
import com.microsoft.graph.models.UserConsentRequest;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Request
extends Entity
implements Parsable {
    @Nonnull
    public static Request createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.privilegedAccessGroupAssignmentScheduleRequest": {
                    return new PrivilegedAccessGroupAssignmentScheduleRequest();
                }
                case "#microsoft.graph.privilegedAccessGroupEligibilityScheduleRequest": {
                    return new PrivilegedAccessGroupEligibilityScheduleRequest();
                }
                case "#microsoft.graph.privilegedAccessScheduleRequest": {
                    return new PrivilegedAccessScheduleRequest();
                }
                case "#microsoft.graph.unifiedRoleAssignmentScheduleRequest": {
                    return new UnifiedRoleAssignmentScheduleRequest();
                }
                case "#microsoft.graph.unifiedRoleEligibilityScheduleRequest": {
                    return new UnifiedRoleEligibilityScheduleRequest();
                }
                case "#microsoft.graph.userConsentRequest": {
                    return new UserConsentRequest();
                }
            }
        }
        return new Request();
    }

    @Nullable
    public String getApprovalId() {
        return (String)this.backingStore.get("approvalId");
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getCustomData() {
        return (String)this.backingStore.get("customData");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("approvalId", n -> this.setApprovalId(n.getStringValue()));
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customData", n -> this.setCustomData(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getStatus() {
        return (String)this.backingStore.get("status");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("approvalId", this.getApprovalId());
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("customData", this.getCustomData());
        writer.writeStringValue("status", this.getStatus());
    }

    public void setApprovalId(@Nullable String value) {
        this.backingStore.set("approvalId", (Object)value);
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomData(@Nullable String value) {
        this.backingStore.set("customData", (Object)value);
    }

    public void setStatus(@Nullable String value) {
        this.backingStore.set("status", (Object)value);
    }
}

