/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.QuarantineReason;
import com.microsoft.graph.models.SynchronizationError;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SynchronizationQuarantine
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SynchronizationQuarantine() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SynchronizationQuarantine createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SynchronizationQuarantine();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getCurrentBegan() {
        return (OffsetDateTime)this.backingStore.get("currentBegan");
    }

    @Nullable
    public SynchronizationError getError() {
        return (SynchronizationError)this.backingStore.get("error");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("currentBegan", n -> this.setCurrentBegan(n.getOffsetDateTimeValue()));
        deserializerMap.put("error", n -> this.setError((SynchronizationError)n.getObjectValue(SynchronizationError::createFromDiscriminatorValue)));
        deserializerMap.put("nextAttempt", n -> this.setNextAttempt(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("reason", n -> this.setReason((QuarantineReason)n.getEnumValue(QuarantineReason::forValue)));
        deserializerMap.put("seriesBegan", n -> this.setSeriesBegan(n.getOffsetDateTimeValue()));
        deserializerMap.put("seriesCount", n -> this.setSeriesCount(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getNextAttempt() {
        return (OffsetDateTime)this.backingStore.get("nextAttempt");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public QuarantineReason getReason() {
        return (QuarantineReason)((Object)this.backingStore.get("reason"));
    }

    @Nullable
    public OffsetDateTime getSeriesBegan() {
        return (OffsetDateTime)this.backingStore.get("seriesBegan");
    }

    @Nullable
    public Long getSeriesCount() {
        return (Long)this.backingStore.get("seriesCount");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("currentBegan", this.getCurrentBegan());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("nextAttempt", this.getNextAttempt());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("reason", (Enum)this.getReason());
        writer.writeOffsetDateTimeValue("seriesBegan", this.getSeriesBegan());
        writer.writeLongValue("seriesCount", this.getSeriesCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCurrentBegan(@Nullable OffsetDateTime value) {
        this.backingStore.set("currentBegan", (Object)value);
    }

    public void setError(@Nullable SynchronizationError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setNextAttempt(@Nullable OffsetDateTime value) {
        this.backingStore.set("nextAttempt", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReason(@Nullable QuarantineReason value) {
        this.backingStore.set("reason", (Object)value);
    }

    public void setSeriesBegan(@Nullable OffsetDateTime value) {
        this.backingStore.set("seriesBegan", (Object)value);
    }

    public void setSeriesCount(@Nullable Long value) {
        this.backingStore.set("seriesCount", (Object)value);
    }
}

