/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.ContainerEvidence;
import com.microsoft.graph.models.security.Dictionary;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.graph.models.security.KubernetesControllerEvidence;
import com.microsoft.graph.models.security.KubernetesNamespaceEvidence;
import com.microsoft.graph.models.security.KubernetesServiceAccountEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class KubernetesPodEvidence
extends AlertEvidence
implements Parsable {
    public KubernetesPodEvidence() {
        this.setOdataType("#microsoft.graph.security.kubernetesPodEvidence");
    }

    @Nonnull
    public static KubernetesPodEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new KubernetesPodEvidence();
    }

    @Nullable
    public List<ContainerEvidence> getContainers() {
        return (List)this.backingStore.get("containers");
    }

    @Nullable
    public KubernetesControllerEvidence getController() {
        return (KubernetesControllerEvidence)this.backingStore.get("controller");
    }

    @Nullable
    public List<ContainerEvidence> getEphemeralContainers() {
        return (List)this.backingStore.get("ephemeralContainers");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("containers", n -> this.setContainers(n.getCollectionOfObjectValues(ContainerEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("controller", n -> this.setController((KubernetesControllerEvidence)n.getObjectValue(KubernetesControllerEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("ephemeralContainers", n -> this.setEphemeralContainers(n.getCollectionOfObjectValues(ContainerEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("initContainers", n -> this.setInitContainers(n.getCollectionOfObjectValues(ContainerEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("labels", n -> this.setLabels((Dictionary)n.getObjectValue(Dictionary::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("namespace", n -> this.setNamespace((KubernetesNamespaceEvidence)n.getObjectValue(KubernetesNamespaceEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("podIp", n -> this.setPodIp((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("serviceAccount", n -> this.setServiceAccount((KubernetesServiceAccountEvidence)n.getObjectValue(KubernetesServiceAccountEvidence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<ContainerEvidence> getInitContainers() {
        return (List)this.backingStore.get("initContainers");
    }

    @Nullable
    public Dictionary getLabels() {
        return (Dictionary)this.backingStore.get("labels");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public KubernetesNamespaceEvidence getNamespace() {
        return (KubernetesNamespaceEvidence)this.backingStore.get("namespace");
    }

    @Nullable
    public IpEvidence getPodIp() {
        return (IpEvidence)this.backingStore.get("podIp");
    }

    @Nullable
    public KubernetesServiceAccountEvidence getServiceAccount() {
        return (KubernetesServiceAccountEvidence)this.backingStore.get("serviceAccount");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("containers", this.getContainers());
        writer.writeObjectValue("controller", (Parsable)this.getController(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("ephemeralContainers", this.getEphemeralContainers());
        writer.writeCollectionOfObjectValues("initContainers", this.getInitContainers());
        writer.writeObjectValue("labels", (Parsable)this.getLabels(), new Parsable[0]);
        writer.writeStringValue("name", this.getName());
        writer.writeObjectValue("namespace", (Parsable)this.getNamespace(), new Parsable[0]);
        writer.writeObjectValue("podIp", (Parsable)this.getPodIp(), new Parsable[0]);
        writer.writeObjectValue("serviceAccount", (Parsable)this.getServiceAccount(), new Parsable[0]);
    }

    public void setContainers(@Nullable List<ContainerEvidence> value) {
        this.backingStore.set("containers", value);
    }

    public void setController(@Nullable KubernetesControllerEvidence value) {
        this.backingStore.set("controller", (Object)value);
    }

    public void setEphemeralContainers(@Nullable List<ContainerEvidence> value) {
        this.backingStore.set("ephemeralContainers", value);
    }

    public void setInitContainers(@Nullable List<ContainerEvidence> value) {
        this.backingStore.set("initContainers", value);
    }

    public void setLabels(@Nullable Dictionary value) {
        this.backingStore.set("labels", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setNamespace(@Nullable KubernetesNamespaceEvidence value) {
        this.backingStore.set("namespace", (Object)value);
    }

    public void setPodIp(@Nullable IpEvidence value) {
        this.backingStore.set("podIp", (Object)value);
    }

    public void setServiceAccount(@Nullable KubernetesServiceAccountEvidence value) {
        this.backingStore.set("serviceAccount", (Object)value);
    }
}

