/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageAutomaticRequestSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AccessPackageAutomaticRequestSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AccessPackageAutomaticRequestSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessPackageAutomaticRequestSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("gracePeriodBeforeAccessRemoval", n -> this.setGracePeriodBeforeAccessRemoval(n.getPeriodAndDurationValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("removeAccessWhenTargetLeavesAllowedTargets", n -> this.setRemoveAccessWhenTargetLeavesAllowedTargets(n.getBooleanValue()));
        deserializerMap.put("requestAccessForAllowedTargets", n -> this.setRequestAccessForAllowedTargets(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public PeriodAndDuration getGracePeriodBeforeAccessRemoval() {
        return (PeriodAndDuration)this.backingStore.get("gracePeriodBeforeAccessRemoval");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getRemoveAccessWhenTargetLeavesAllowedTargets() {
        return (Boolean)this.backingStore.get("removeAccessWhenTargetLeavesAllowedTargets");
    }

    @Nullable
    public Boolean getRequestAccessForAllowedTargets() {
        return (Boolean)this.backingStore.get("requestAccessForAllowedTargets");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writePeriodAndDurationValue("gracePeriodBeforeAccessRemoval", this.getGracePeriodBeforeAccessRemoval());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("removeAccessWhenTargetLeavesAllowedTargets", this.getRemoveAccessWhenTargetLeavesAllowedTargets());
        writer.writeBooleanValue("requestAccessForAllowedTargets", this.getRequestAccessForAllowedTargets());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setGracePeriodBeforeAccessRemoval(@Nullable PeriodAndDuration value) {
        this.backingStore.set("gracePeriodBeforeAccessRemoval", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRemoveAccessWhenTargetLeavesAllowedTargets(@Nullable Boolean value) {
        this.backingStore.set("removeAccessWhenTargetLeavesAllowedTargets", (Object)value);
    }

    public void setRequestAccessForAllowedTargets(@Nullable Boolean value) {
        this.backingStore.set("requestAccessForAllowedTargets", (Object)value);
    }
}

